<?php
/**
 * Class1TokenApi
 * PHP version 5
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * 
 *
 * OpenAPI spec version: 1.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.15
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * Class1TokenApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TokenApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation tokenGet
     *
     * Get access token
     *
     * @param  string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param  string $grantType Grant type (required)
     *
     * @throws \RTMTrade\OpenCart\AdminApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \RTMTrade\OpenCart\AdminApi\Model\ApiResponse
     */
    public function tokenGet($authorization, $grantType)
    {
        list($response) = $this->tokenGetWithHttpInfo($authorization, $grantType);
        return $response;
    }

    /**
     * Operation tokenGetWithHttpInfo
     *
     * Get access token
     *
     * @param  string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param  string $grantType Grant type (required)
     *
     * @throws \RTMTrade\OpenCart\AdminApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function tokenGetWithHttpInfo($authorization, $grantType)
    {
        $request = $this->tokenGetRequest($authorization, $grantType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\RTMTrade\OpenCart\AdminApi\Model\ApiResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\RTMTrade\OpenCart\AdminApi\Model\ApiResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\RTMTrade\OpenCart\AdminApi\Model\ApiResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\RTMTrade\OpenCart\AdminApi\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation tokenGetAsync
     *
     * Get access token
     *
     * @param  string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param  string $grantType Grant type (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function tokenGetAsync($authorization, $grantType)
    {
        return $this->tokenGetAsyncWithHttpInfo($authorization, $grantType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation tokenGetAsyncWithHttpInfo
     *
     * Get access token
     *
     * @param  string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param  string $grantType Grant type (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function tokenGetAsyncWithHttpInfo($authorization, $grantType)
    {
        $returnType = '\RTMTrade\OpenCart\AdminApi\Model\ApiResponse';
        $request = $this->tokenGetRequest($authorization, $grantType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'tokenGet'
     *
     * @param  string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param  string $grantType Grant type (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function tokenGetRequest($authorization, $grantType)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling tokenGet'
            );
        }
        // verify the required parameter 'grantType' is set
        if ($grantType === null || (is_array($grantType) && count($grantType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $grantType when calling tokenGet'
            );
        }

        $resourcePath = '/oauth2/token/{grant_type}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($grantType !== null) {
            $resourcePath = str_replace(
                '{' . 'grant_type' . '}',
                ObjectSerializer::toPathValue($grantType),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
