# RTMTrade\OpenCart\AdminApi\ProductsApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productAdd**](ProductsApi.md#productAdd) | **POST** /products | Add new product to store
[**productBulkAdd**](ProductsApi.md#productBulkAdd) | **POST** /bulk_products | Add multiple products to store
[**productBulkUpdate**](ProductsApi.md#productBulkUpdate) | **PUT** /products/quantity | Update products quantity
[**productBulkUpdate1**](ProductsApi.md#productBulkUpdate1) | **PUT** /bulk_products | Update multiple products to store
[**productBulkUpdateSku**](ProductsApi.md#productBulkUpdateSku) | **PUT** /products/quantitybysku | Update products quantity by sku
[**productDelete**](ProductsApi.md#productDelete) | **DELETE** /products/{id} | Delete product by ID
[**productUpdate**](ProductsApi.md#productUpdate) | **PUT** /products/{id} | Update product by ID
[**productsByLevel**](ProductsApi.md#productsByLevel) | **GET** /products/category/{id} | Get list of products by category ID
[**productsDetails**](ProductsApi.md#productsDetails) | **GET** /products/{id} | Get product details by ID
[**productsGetproductbysku**](ProductsApi.md#productsGetproductbysku) | **GET** /products/getproductbysku/{sku} | Get product by sku
[**productsInsertOtherImage**](ProductsApi.md#productsInsertOtherImage) | **POST** /products/{id}/images/other/{sort_order} | Add image to product by product ID, you can send an array of images too.
[**productsList**](ProductsApi.md#productsList) | **GET** /products | Get list of products
[**productsPagination**](ProductsApi.md#productsPagination) | **GET** /products/category/{id}/limit/{limit}/page/{page} | Get list of products by category ID and page and limit
[**productsPagination1**](ProductsApi.md#productsPagination1) | **GET** /products/limit/{limit}/page/{page} | Get list of products by page and limit
[**productsSearch**](ProductsApi.md#productsSearch) | **GET** /products/search/{search} | Search products
[**productsSearchPagination**](ProductsApi.md#productsSearchPagination) | **GET** /products/search/{search}/limit/{limit}/page/{page} | Search products by page and limit
[**productsUpdateImage**](ProductsApi.md#productsUpdateImage) | **POST** /products/{id}/images | Set primary image to product by product ID



## productAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productAdd($productObject)

Add new product to store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products</span><br><br>You can send option value's sku, if your system support this feature<pre>\"product_option_value\": [<br/>&#9;{<br/>&#9;\"price\": 10,<br/>&#9;\"price_prefix\": \"+\",<br/>&#9;\"subtract\": \"0\",<br/>&#9;\"shipping\": \"0\",<br/>&#9;\"points\": \"0\",<br/>&#9;\"points_prefix\": \"0\",<br/>&#9;\"weight\": \"0\",<br/>&#9;\"weight_prefix\":\"0\",<br/>&#9;\"option_value_id\": \"46\",<br/>&#9;\"quantity\": \"300\",<br/>&#9;\"option_sku\": \"demo_option_sku\"<br/>}<br/>]</pre>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$productObject = new \RTMTrade\OpenCart\AdminApi\Model\Product(); // \RTMTrade\OpenCart\AdminApi\Model\Product | Product object

try {
    $result = $apiInstance->productAdd($productObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Product**](../Model/Product.md)| Product object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productBulkAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productBulkAdd($productObject)

Add multiple products to store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/bulk_products</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/bulkproducts</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$productObject = array(new \RTMTrade\OpenCart\AdminApi\Model\Product()); // \RTMTrade\OpenCart\AdminApi\Model\Product[] | Array of product objects

try {
    $result = $apiInstance->productBulkAdd($productObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productBulkAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Product[]**](../Model/Product.md)| Array of product objects |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productBulkUpdate

> productBulkUpdate($arrayOfProductQuantityObjects)

Update products quantity

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/quantity</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/productquantity</span><br>If you want to update product option's quantity:<br><pre>[<br>&#9;{<br><br>&#9;&#9;\"product_id\":34,<br>&#9;&#9;\"product_option\":[<br>&#9;&#9;&#9;{<br>&#9;&#9;&#9;&#9;\"product_option_value\":[<br>&#9;&#9;&#9;&#9;&#9;{<br>&#9;&#9;&#9;&#9;&#9;&#9;\"product_option_value_id\":21,<br>&#9;&#9;&#9;&#9;&#9;&#9;\"quantity\":10<br>&#9;&#9;&#9;&#9;&#9;},<br>&#9;&#9;&#9;&#9;&#9;{<br>&#9;&#9;&#9;&#9;&#9;&#9;\"product_option_value_id\":22,<br>&#9;&#9;&#9;&#9;&#9;&#9;\"quantity\":11<br>&#9;&#9;&#9;&#9;&#9;},<br>&#9;&#9;&#9;&#9;&#9;{<br>&#9;&#9;&#9;&#9;&#9;&#9;\"product_option_value_id\":23,<br>&#9;&#9;&#9;&#9;&#9;&#9;\"quantity\":20<br>&#9;&#9;&#9;&#9;&#9;}<br>&#9;&#9;&#9;&#9;]<br>&#9;&#9;&#9;}<br>&#9;&#9;]<br>&#9;}<br>]</pre>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$arrayOfProductQuantityObjects = array(new \RTMTrade\OpenCart\AdminApi\Model\ProductQuantity()); // \RTMTrade\OpenCart\AdminApi\Model\ProductQuantity[] | Array of Product quantity objects

try {
    $apiInstance->productBulkUpdate($arrayOfProductQuantityObjects);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productBulkUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **arrayOfProductQuantityObjects** | [**\RTMTrade\OpenCart\AdminApi\Model\ProductQuantity[]**](../Model/ProductQuantity.md)| Array of Product quantity objects |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productBulkUpdate1

> productBulkUpdate1($productObject)

Update multiple products to store

<strong>IMPORTANT: You should send all option, category, attribute if you want to modify one of these information, because if you miss an item for example from the category array, it will be removed.This is the way how you can remove an option or category.</strong><br><br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/bulk_products</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/bulkproducts</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$productObject = array(new \RTMTrade\OpenCart\AdminApi\Model\BulkProductEditObject()); // \RTMTrade\OpenCart\AdminApi\Model\BulkProductEditObject[] | Array of product objects

try {
    $apiInstance->productBulkUpdate1($productObject);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productBulkUpdate1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productObject** | [**\RTMTrade\OpenCart\AdminApi\Model\BulkProductEditObject[]**](../Model/BulkProductEditObject.md)| Array of product objects |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productBulkUpdateSku

> productBulkUpdateSku($productQuantityObjects)

Update products quantity by sku

First this service tries to update product option's quantity by sku, if the option does not exist, then it tries to update product's quantity by sku.<br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/quantitybysku</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/productquantitybysku</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$productQuantityObjects = array(new \RTMTrade\OpenCart\AdminApi\Model\ProductQuantitySku()); // \RTMTrade\OpenCart\AdminApi\Model\ProductQuantitySku[] | Array of Product quantity objects

try {
    $apiInstance->productBulkUpdateSku($productQuantityObjects);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productBulkUpdateSku: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **productQuantityObjects** | [**\RTMTrade\OpenCart\AdminApi\Model\ProductQuantitySku[]**](../Model/ProductQuantitySku.md)| Array of Product quantity objects |

### Return type

void (empty response body)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productDelete($id)

Delete product by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/{product_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&id={product_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Product Id

try {
    $result = $apiInstance->productDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productUpdate($id, $productObject)

Update product by ID

<strong>IMPORTANT: You should send all option, category, attribute if you want to modify one of these information, because if you miss an item for example from the category array, it will be removed.This is the way how you can remove an option or category.</strong><br><br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/{product_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&id={product_id}</span><br><br>You can send option value's sku, if your system support this feature<pre>\"product_option_value\": [<br/>&#9;{<br/>&#9;\"price\": 10,<br/>&#9;\"price_prefix\": \"+\",<br/>&#9;\"subtract\": \"0\",<br/>&#9;\"points\": \"0\",<br/>&#9;\"points_prefix\": \"0\",<br/>&#9;\"weight\": \"0\",<br/>&#9;\"weight_prefix\":\"0\",<br/>&#9;\"option_value_id\": \"46\",<br/>&#9;\"quantity\": \"300\",<br/>&#9;\"option_sku\": \"demo_option_sku\"<br/>}<br/>]</pre><br/><b>Possible update only specific fields /sku, model, quantity, status, price, manufacturer_id, sort_order, tax_class_id/</b><br/><br/><i>ONLY product_id is mandatory</i><br/><pre><br/>{<br/>&#9;\"model\": \"test_model\",<br/>&#9;\"quantity\": \"2\" <br/>}</pre><br/>OR<br/><pre><br/>{<br/>&#9;\"quantity\": \"2\"<br/>&#9;<br/>}</pre><br/>If you only want to update the quantity of the product options and some product data:<pre>{<br/>&#9;&#9;\"product_id\": \"30\",<br/>&#9;&#9;\"quantity\": \"996\",<br/>&#9;&#9;\"price\": \"198\",<br>&#9;&#9;\"product_option_quantity_update\": \"1\",<br/>&#9;&#9;\"product_option\": [<br/>&#9;&#9;{<br/>&#9;&#9;\"product_option_value\":<br/>&#9;&#9;[<br/>&#9;&#9;&#9;{<br/>&#9;&#9;&#9;&#9;\"product_option_value_id\": \"15\",<br/>&#9;&#9;&#9;&#9;\"quantity\": \"122\"<br/>&#9;&#9;&#9;},<br/>&#9;&#9;&#9;{<br/>&#9;&#9;&#9;&#9;\"product_option_value_id\": \"16\",<br/>&#9;&#9;&#9;&#9;\"quantity\": \"211\"<br/>&#9;&#9;&#9;}<br/>&#9;&#9;&#9;]<br/>&#9;&#9;&#9;}<br/>&#9;&#9;]<br/>&#9;}</pre><br/>If you only want to update the quantity and price of the product options and some product data:<pre>{<br/>&#9;&#9;\"product_id\": \"30\",<br/>&#9;&#9;\"quantity\": \"996\",<br/>&#9;&#9;\"price\": \"198\",<br>&#9;&#9;\"product_option_update\": \"1\",<br/>&#9;&#9;\"product_option\": [<br/>&#9;&#9;{<br/>&#9;&#9;\"product_option_value\":<br/>&#9;&#9;[<br/>&#9;&#9;&#9;{<br/>&#9;&#9;&#9;&#9;\"product_option_value_id\": \"15\",<br/>&#9;&#9;&#9;&#9;\"quantity\": \"122\",<br/>&#9;&#9;&#9;&#9;\"price\": \"10\"<br/>&#9;&#9;&#9;},<br/>&#9;&#9;&#9;{<br/>&#9;&#9;&#9;&#9;\"product_option_value_id\": \"16\",<br/>&#9;&#9;&#9;&#9;\"quantity\": \"211\",<br/>&#9;&#9;&#9;&#9;\"price\": \"5\"<br/>&#9;&#9;&#9;}<br/>&#9;&#9;&#9;]<br/>&#9;&#9;&#9;}<br/>&#9;&#9;]<br/>&#9;}</pre>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Product Id
$productObject = new \RTMTrade\OpenCart\AdminApi\Model\ProductEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\ProductEditObject | Product object

try {
    $result = $apiInstance->productUpdate($id, $productObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product Id |
 **productObject** | [**\RTMTrade\OpenCart\AdminApi\Model\ProductEditObject**](../Model/ProductEditObject.md)| Product object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsByLevel

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsByLevel($id)

Get list of products by category ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/category/{category_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&category={category_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 20; // int | Product's category id

try {
    $result = $apiInstance->productsByLevel($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsByLevel: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product&#39;s category id | [default to 20]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsDetails($id)

Get product details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/{product_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&id={product_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 34; // int | Product Id

try {
    $result = $apiInstance->productsDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product Id | [default to 34]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsGetproductbysku

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsGetproductbysku($sku)

Get product by sku

Get product by sku. If you have product option sku, you can use this sku in this service too.<br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/getproductbysku/{sku}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/getproductbysku&sku={sku}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'demosku'; // string | Sku

try {
    $result = $apiInstance->productsGetproductbysku($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsGetproductbysku: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**| Sku | [default to &#39;demosku&#39;]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsInsertOtherImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsInsertOtherImage($id, $sortOrder, $file)

Add image to product by product ID, you can send an array of images too.

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/{id}/images/other/{sort_order}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/productimages&id={id}&other=1&sort_order={sort_order}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Product Id
$sortOrder = 0; // int | Sort order
$file = "/path/to/file.txt"; // \SplFileObject | 

try {
    $result = $apiInstance->productsInsertOtherImage($id, $sortOrder, $file);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsInsertOtherImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product Id |
 **sortOrder** | **int**| Sort order | [default to 0]
 **file** | **\SplFileObject****\SplFileObject**|  |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsList()

Get list of products

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productsList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsPagination

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsPagination($id, $limit, $page)

Get list of products by category ID and page and limit

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/category/{category_id}/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&category={category_id}&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 20; // int | Product's category id
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->productsPagination($id, $limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsPagination: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product&#39;s category id | [default to 20]
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsPagination1

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsPagination1($limit, $page)

Get list of products by page and limit

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->productsPagination1($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsPagination1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsSearch

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsSearch($search)

Search products

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/search/{search}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&search={search}</span><br><h4>Search products with opencart rest api</h4><p>You can combine filter parameters, you only need to use the long version of API urls.</p><div>You can combine these parameters:</div><ul><li>- limit</li><li>- page</li><li>- start</li><li>- sort (sorty by name, model, quantity, rating, sort order, date_added)</li><li>- order (order by desc or asc)</li><li>- search (search keyword, search in product name, model, sku, upc, ean, jan, isbn, mpn)</li><li>- filter_description (set this parameter 1, then the API will search in description too)</li><li>- filters</li><li>- manufacturer (manufacturer ID)</li><li>- category (category ID)</li><li>- subcategory (subcategory ID)</li><li>- tag</li><li>- filter_date_modified_from</li><li>- filter_date_modified_to</li><li>- filter_date_added_from</li><li>- filter_date_added_to</li></ul><br/>Example urls:<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&filter_date_modified_from=2016-04-21</span><br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&filter_date_modified_from=2016-04-21 10:00:00</span><br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&filter_date_modified_from=2016-04-21&filter_date_modified_to=2016-04-22</span><br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&filter_date_modified_from=2016-04-21&limit=10&page=1</span><br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&filter_date_added_from=2016-04-21</span><br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&manufacturer=8</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$search = 'apple'; // string | Search text

try {
    $result = $apiInstance->productsSearch($search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Search text | [default to &#39;apple&#39;]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsSearchPagination

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsSearchPagination($search, $limit, $page)

Search products by page and limit

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/search/{search}/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/products&search={search}&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$search = 'apple'; // string | Search text
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->productsSearchPagination($search, $limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsSearchPagination: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| Search text | [default to &#39;apple&#39;]
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsUpdateImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsUpdateImage($id, $file)

Set primary image to product by product ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/products/{id}/images</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/productimages&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Product Id
$file = "/path/to/file.txt"; // \SplFileObject | 

try {
    $result = $apiInstance->productsUpdateImage($id, $file);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->productsUpdateImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Product Id |
 **file** | **\SplFileObject****\SplFileObject**|  |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

