# RTMTrade\OpenCart\AdminApi\ProductFilterApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**filtersList**](ProductFilterApi.md#filtersList) | **GET** /product_filters/filters/limit/{limit}/page/{page} | Get product filters
[**filtersListByGroup**](ProductFilterApi.md#filtersListByGroup) | **GET** /product_filters/filters/group/{id} | Get product filters by filter group id
[**groupsList**](ProductFilterApi.md#groupsList) | **GET** /product_filters/groups/limit/{limit}/page/{page} | Get product filter groups



## filtersList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse filtersList($limit, $page)

Get product filters

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/product_filters/filters/limit/{limit}/page/{page}</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/filter_admin/filters&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFilterApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->filtersList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFilterApi->filtersList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## filtersListByGroup

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse filtersListByGroup($id)

Get product filters by filter group id

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/product_filters/filters/group/{id}</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/filter_admin/filters&filter_group={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFilterApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | group id

try {
    $result = $apiInstance->filtersListByGroup($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFilterApi->filtersListByGroup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| group id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## groupsList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse groupsList($limit, $page)

Get product filter groups

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/product_filters/groups/limit/{limit}/page/{page}</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/filter_admin/groups&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFilterApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->groupsList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFilterApi->groupsList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

