# RTMTrade\OpenCart\AdminApi\ProductAttributeGroupsApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**attributegroupAdd**](ProductAttributeGroupsApi.md#attributegroupAdd) | **POST** /attributegroups | Add new attribute group
[**attributegroupDelete**](ProductAttributeGroupsApi.md#attributegroupDelete) | **DELETE** /attributegroups/{id} | Delete attribute group by ID
[**attributegroupDeleteMultiple**](ProductAttributeGroupsApi.md#attributegroupDeleteMultiple) | **DELETE** /attributegroups | Delete attribute groups
[**attributegroupList**](ProductAttributeGroupsApi.md#attributegroupList) | **GET** /attributegroups/limit/{limit}/page/{page} | Get attribute groups
[**attributegroupModify**](ProductAttributeGroupsApi.md#attributegroupModify) | **PUT** /attributegroups/{id} | Modify attribute group



## attributegroupAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributegroupAdd($attributeGroupObject)

Add new attribute group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributegroups</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_group_admin/attributegroup</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeGroupObject = new \RTMTrade\OpenCart\AdminApi\Model\AttributeGroup(); // \RTMTrade\OpenCart\AdminApi\Model\AttributeGroup | AttributeGroup object

try {
    $result = $apiInstance->attributegroupAdd($attributeGroupObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeGroupsApi->attributegroupAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeGroupObject** | [**\RTMTrade\OpenCart\AdminApi\Model\AttributeGroup**](../Model/AttributeGroup.md)| AttributeGroup object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributegroupDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributegroupDelete($id)

Delete attribute group by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributegroups/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_group_admin/attributegroup&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Attribute group Id

try {
    $result = $apiInstance->attributegroupDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeGroupsApi->attributegroupDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Attribute group Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributegroupDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributegroupDeleteMultiple($attributeGroupIds)

Delete attribute groups

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributegroups</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_group_admin/attributegroup</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeGroupIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteAttributeGroups(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteAttributeGroups | Attribute group ids

try {
    $result = $apiInstance->attributegroupDeleteMultiple($attributeGroupIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeGroupsApi->attributegroupDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeGroupIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteAttributeGroups**](../Model/DeleteAttributeGroups.md)| Attribute group ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributegroupList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributegroupList($limit, $page)

Get attribute groups

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributegroups/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_group_admin/attributegroup&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->attributegroupList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeGroupsApi->attributegroupList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributegroupModify

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributegroupModify($id, $attributeGroupObject)

Modify attribute group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributegroups/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_group_admin/attributegroup&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 1; // int | Attribute group Id
$attributeGroupObject = new \RTMTrade\OpenCart\AdminApi\Model\AttributeGroupEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\AttributeGroupEditObject | AttributeGroup object

try {
    $result = $apiInstance->attributegroupModify($id, $attributeGroupObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeGroupsApi->attributegroupModify: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Attribute group Id | [default to 1]
 **attributeGroupObject** | [**\RTMTrade\OpenCart\AdminApi\Model\AttributeGroupEditObject**](../Model/AttributeGroupEditObject.md)| AttributeGroup object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

