# RTMTrade\OpenCart\AdminApi\ProductAttributeApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**attributeAdd**](ProductAttributeApi.md#attributeAdd) | **POST** /attributes | Add new attribute
[**attributeDelete**](ProductAttributeApi.md#attributeDelete) | **DELETE** /attributes/{id} | Delete attribute by ID
[**attributeDeleteMultiple**](ProductAttributeApi.md#attributeDeleteMultiple) | **DELETE** /attributes | Delete attribute
[**attributesList**](ProductAttributeApi.md#attributesList) | **GET** /attributes/limit/{limit}/page/{page} | Get list of product attributes
[**attributesList1**](ProductAttributeApi.md#attributesList1) | **GET** /attributes/group/{group_id}/limit/{limit}/page/{page} | Get list of product attributes filter by group



## attributeAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributeAdd($attributeObject)

Add new attribute

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributes</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_admin/attributes</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeObject = new \RTMTrade\OpenCart\AdminApi\Model\Attribute(); // \RTMTrade\OpenCart\AdminApi\Model\Attribute | Attribute object

try {
    $result = $apiInstance->attributeAdd($attributeObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->attributeAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Attribute**](../Model/Attribute.md)| Attribute object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributeDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributeDelete($id)

Delete attribute by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributes/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_admin/attributes&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Attribute Id

try {
    $result = $apiInstance->attributeDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->attributeDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Attribute Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributeDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributeDeleteMultiple($attributeIds)

Delete attribute

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributes</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_admin/attributes</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attributeIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteAttributes(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteAttributes | Attribute ids

try {
    $result = $apiInstance->attributeDeleteMultiple($attributeIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->attributeDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attributeIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteAttributes**](../Model/DeleteAttributes.md)| Attribute ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributesList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributesList($limit, $page)

Get list of product attributes

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributes/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_admin/attribute&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->attributesList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->attributesList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## attributesList1

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse attributesList1($groupId, $limit, $page)

Get list of product attributes filter by group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/attributes/group/{group_id}/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/attribute_admin/attribute&group={group}&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$groupId = 6; // int | Group id
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->attributesList1($groupId, $limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->attributesList1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **int**| Group id | [default to 6]
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

