# RTMTrade\OpenCart\AdminApi\ManufacturerApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**manufacturerAdd**](ManufacturerApi.md#manufacturerAdd) | **POST** /manufacturers | Add new manufacturer to store
[**manufacturerDelete**](ManufacturerApi.md#manufacturerDelete) | **DELETE** /manufacturers/{id} | Delete manufacturer by ID
[**manufacturerDeleteMultiple**](ManufacturerApi.md#manufacturerDeleteMultiple) | **DELETE** /manufacturers | Delete manufacturers
[**manufacturerList**](ManufacturerApi.md#manufacturerList) | **GET** /manufacturers/limit/{limit}/page/{page} | Get list of manufacturers
[**manufacturerUpdate**](ManufacturerApi.md#manufacturerUpdate) | **PUT** /manufacturers/{id} | Update manufacturer by ID
[**manufacturerUpdateImage**](ManufacturerApi.md#manufacturerUpdateImage) | **POST** /manufacturers/{id}/images | Add image to manufacturer by manufacturer ID



## manufacturerAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerAdd($manufacturerObject)

Add new manufacturer to store

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturer</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$manufacturerObject = new \RTMTrade\OpenCart\AdminApi\Model\Manufacturer(); // \RTMTrade\OpenCart\AdminApi\Model\Manufacturer | Manufacturer object

try {
    $result = $apiInstance->manufacturerAdd($manufacturerObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **manufacturerObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Manufacturer**](../Model/Manufacturer.md)| Manufacturer object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## manufacturerDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerDelete($id)

Delete manufacturer by ID

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturer&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Manufacturer Id

try {
    $result = $apiInstance->manufacturerDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Manufacturer Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## manufacturerDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerDeleteMultiple($manufacturerIds)

Delete manufacturers

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturer</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$manufacturerIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteManufacturer(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteManufacturer | Manufacturer ids

try {
    $result = $apiInstance->manufacturerDeleteMultiple($manufacturerIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **manufacturerIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteManufacturer**](../Model/DeleteManufacturer.md)| Manufacturer ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## manufacturerList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerList($limit, $page)

Get list of manufacturers

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturer&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->manufacturerList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## manufacturerUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerUpdate($id, $manufacturerObject)

Update manufacturer by ID

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturer&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Manufacturer Id
$manufacturerObject = new \RTMTrade\OpenCart\AdminApi\Model\Manufacturer(); // \RTMTrade\OpenCart\AdminApi\Model\Manufacturer | Manufacturer object

try {
    $result = $apiInstance->manufacturerUpdate($id, $manufacturerObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Manufacturer Id |
 **manufacturerObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Manufacturer**](../Model/Manufacturer.md)| Manufacturer object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## manufacturerUpdateImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse manufacturerUpdateImage($id, $file)

Add image to manufacturer by manufacturer ID

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/manufacturers/{id}/images</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/manufacturer_admin/manufacturerimages&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ManufacturerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 10; // int | Manufacturer Id
$file = "/path/to/file.txt"; // \SplFileObject | 

try {
    $result = $apiInstance->manufacturerUpdateImage($id, $file);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ManufacturerApi->manufacturerUpdateImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Manufacturer Id | [default to 10]
 **file** | **\SplFileObject****\SplFileObject**|  |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

