# RTMTrade\OpenCart\AdminApi\CouponApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**couponAdd**](CouponApi.md#couponAdd) | **POST** /coupons | Add new coupon to store
[**couponDelete**](CouponApi.md#couponDelete) | **DELETE** /coupons/{id} | Delete coupon by ID
[**couponDeleteMultiple**](CouponApi.md#couponDeleteMultiple) | **DELETE** /coupons | Delete coupons
[**couponList**](CouponApi.md#couponList) | **GET** /coupons/limit/{limit}/page/{page} | Get list of coupons
[**couponUpdate**](CouponApi.md#couponUpdate) | **PUT** /coupons/{id} | Update coupon by ID



## couponAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse couponAdd($couponObject)

Add new coupon to store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/coupons</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/coupon_admin/coupon</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CouponApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$couponObject = new \RTMTrade\OpenCart\AdminApi\Model\CouponObject(); // \RTMTrade\OpenCart\AdminApi\Model\CouponObject | coupon object

try {
    $result = $apiInstance->couponAdd($couponObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CouponApi->couponAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **couponObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CouponObject**](../Model/CouponObject.md)| coupon object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## couponDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse couponDelete($id)

Delete coupon by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/coupons/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/coupon_admin/coupon&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CouponApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | coupon Id

try {
    $result = $apiInstance->couponDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CouponApi->couponDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| coupon Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## couponDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse couponDeleteMultiple($couponIds)

Delete coupons

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/coupons</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/coupon_admin/coupon</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CouponApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$couponIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteCoupon(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteCoupon | Coupon ids

try {
    $result = $apiInstance->couponDeleteMultiple($couponIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CouponApi->couponDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **couponIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteCoupon**](../Model/DeleteCoupon.md)| Coupon ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## couponList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse couponList($limit, $page)

Get list of coupons

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/coupons/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/coupon_admin/coupon&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CouponApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->couponList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CouponApi->couponList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## couponUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse couponUpdate($id, $couponObject)

Update coupon by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/coupons/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/coupon_admin/coupon&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CouponApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | coupon Id
$couponObject = new \RTMTrade\OpenCart\AdminApi\Model\CouponEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\CouponEditObject | coupon object

try {
    $result = $apiInstance->couponUpdate($id, $couponObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CouponApi->couponUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| coupon Id |
 **couponObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CouponEditObject**](../Model/CouponEditObject.md)| coupon object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

