# RTMTrade\OpenCart\AdminApi\Class2UserApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**forgotten**](Class2UserApi.md#forgotten) | **POST** /forgotten | Forgotten password
[**loginUser**](Class2UserApi.md#loginUser) | **POST** /login | Logs user into the system
[**logoutUser**](Class2UserApi.md#logoutUser) | **POST** /logout | Logs out current logged in user session
[**reset**](Class2UserApi.md#reset) | **POST** /reset | Reset password
[**userDetails**](Class2UserApi.md#userDetails) | **GET** /user | Get user account details



## forgotten

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse forgotten($forgottenPasswordObject)

Forgotten password

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/forgotten</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/forgotten</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class2UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$forgottenPasswordObject = new \RTMTrade\OpenCart\AdminApi\Model\Forgotten(); // \RTMTrade\OpenCart\AdminApi\Model\Forgotten | Forgotten password object

try {
    $result = $apiInstance->forgotten($forgottenPasswordObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class2UserApi->forgotten: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **forgottenPasswordObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Forgotten**](../Model/Forgotten.md)| Forgotten password object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## loginUser

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse loginUser($loginObject)

Logs user into the system

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/login</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/login</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class2UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$loginObject = new \RTMTrade\OpenCart\AdminApi\Model\Login(); // \RTMTrade\OpenCart\AdminApi\Model\Login | Login object

try {
    $result = $apiInstance->loginUser($loginObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class2UserApi->loginUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **loginObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Login**](../Model/Login.md)| Login object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## logoutUser

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse logoutUser()

Logs out current logged in user session

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/logout</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/logout</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class2UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->logoutUser();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class2UserApi->logoutUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## reset

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse reset($resetPasswordObject)

Reset password

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/reset</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/reset</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class2UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$resetPasswordObject = new \RTMTrade\OpenCart\AdminApi\Model\Reset(); // \RTMTrade\OpenCart\AdminApi\Model\Reset | Reset password object

try {
    $result = $apiInstance->reset($resetPasswordObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class2UserApi->reset: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **resetPasswordObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Reset**](../Model/Reset.md)| Reset password object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## userDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse userDetails()

Get user account details

<span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/user</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/user</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class2UserApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->userDetails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class2UserApi->userDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

