# RTMTrade\OpenCart\AdminApi\Class1TokenApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**tokenGet**](Class1TokenApi.md#tokenGet) | **POST** /oauth2/token/{grant_type} | Get access token



## tokenGet

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse tokenGet($authorization, $grantType)

Get access token

<b>Creating client id/secret</b><br>Before you can authorize with the API you’ll need to set the client id and the secret on REST API admin page.<br>With the client id and client secret you can request an access token using the POST <code>api/rest/oauth2/token</code> api call.<br><br><b>Authenticate API requests with access token</b><br>The received token needs to be added to every API call.<br>Include an Authorization header with the following value: <code>Bearer {access token}</code>.<br>For example: <code>Authorization: Bearer 7487c50afc37dbf6e5a484dc49c363128036c356</code><br><br><span class=\"bold\">Service urls:</span><br><span class=\"links\">http://yourdomain.com/api/rest_admin/oauth2/token/client_credentials</span><br>OR<br><span class=\"links\">http://yourdomain.com/index.php?route=rest/admin_security/gettoken&grant_type=client_credentials</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\Class1TokenApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$authorization = 'Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ='; // string | Authorization header value.<br><br><b>How to create Authorization header value:</b><br><ul><li>Concatenate the client id, a colon character \":\",and the client secret into a single string. So you’ll get <code>client_id:client_secret</code>.</li><li>Base64 encode the concatenated string</li><li>Add \"Basic \" (including the space) before the encoded string.</li><li>If your client id is <code>demo_oauth_client</code> and your client secret is <code>demo_oauth_secret</code>, your concatenated string will be <code>demo_oauth_client:demo_oauth_secret</code>. </li><li>After Base64 encode you will get <code>ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ=</code> and the header parameter will be </li><li><code>Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ=</code></li></ul>
$grantType = 'client_credentials'; // string | Grant type

try {
    $result = $apiInstance->tokenGet($authorization, $grantType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling Class1TokenApi->tokenGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorization** | **string**| Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; | [default to &#39;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&#39;]
 **grantType** | **string**| Grant type | [default to &#39;client_credentials&#39;]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

