<?php
/*
 * Plugin Name:  Add-on: Unsubscribe - Back In Stock Notifier for WooCommerce
 * Description: Unsubscribe in back in stock mail using {cwginstock_unsubscribe} shortcode
 * Author: codewoogeek
 * Plugin URI: https://codewoogeek.online/shop/back-in-stock-notifier/unsubscribe/
 * Author URI: https://codewoogeek.online
 * Version: 1.2
 * Domain Path: /languages
 * WC requires at least: 2.2.0
 * WC tested up to: 3.5.1
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('CWG_Instock_Notifier_Unsubscribe')) {

    class CWG_Instock_Notifier_Unsubscribe {

        public function __construct() {
            register_activation_hook(__FILE__, array($this, 'create_unsubscribe_page'));
            add_shortcode('cwginstocknotifier_unsubscribe', array($this, 'perform_unsubscribe_from_page'));
            add_filter('cwginstock_replace_shortcode', array($this, 'generate_unsubscribe_link'), 10, 2);
            add_action('cwginstock_unsubscribe_url_validated', array($this, 'perform_action_after_url_validated'));
            add_action('wp', array($this, 'set_forbidden_error'));
            //register settings
            add_action('cwginstock_register_settings', array($this, 'register_settings'));
            add_action('cwginstock_settings_default', array($this, 'default_values'));
            $this->include_files();
            add_action('plugins_loaded', array($this, 'load_plugin_textdomain'));
            register_activation_hook(__FILE__, array('CWG_Instock_Unsubscribe_Myaccount', 'install'));
        }

        public function include_files() {
            include('includes/class-unsubscribe-myaccount.php');
        }

        public function create_unsubscribe_page() {
            $page_title = __('Unsubscribe', 'cwginstocknotifier-unsubscribe');
            $page_content = "[cwginstocknotifier_unsubscribe]";
            $check = get_page_by_title($page_title);
            if (!isset($check->ID)) {
                $unsubscribe_page = array(
                    'post_type' => 'page',
                    'post_title' => $page_title,
                    'post_content' => $page_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                );
                //create page
                $unsubscribe_id = wp_insert_post($unsubscribe_page);
                if ($unsubscribe_id) {
                    $options = get_option('cwginstock-unsubscribe-settings', array());
                    $options['page_id'] = $unsubscribe_id;
                    add_option('cwginstock-unsubscribe-settings', $options);
                }
            }
        }

        public function perform_unsubscribe_from_page() {
            ob_start();
            if (isset($_GET['id']) && isset($_GET['hash'])) {
                $email = get_post_meta($_REQUEST['id'], 'cwginstock_subscriber_email', true);
                $get_settings = get_option('cwginstock-unsub-settings');
                $expected = md5($_GET['id'] . $email);
                if ($_GET['hash'] != $expected) {
                    echo $get_settings['error_message'];
                    return;
                }
                // perform action
                do_action('cwginstock_unsubscribe_url_validated', $_GET['id']);
            } else {
                ob_start();
                // Open this to load login form and list of their subscriptions
                $get_myaccount_page = get_permalink(wc_get_page_id('myaccount'));
            }
            return ob_get_clean();
        }

        public function generate_unsubscribe_link($content, $subscribe_id) {
            $get_option = get_option('cwginstock-unsubscribe-settings');
            $get_page = $get_option['page_id'];
            $permalink = get_permalink($get_page);
            $string = get_post_meta($subscribe_id, 'cwginstock_subscriber_email', true);
            $md5_hash = md5($subscribe_id . $string);
            $query_arg = esc_url_raw(add_query_arg(array('id' => $subscribe_id, 'hash' => $md5_hash), $permalink));
            $replace_shortcode = str_replace('{cwginstock_unsubscribe}', $query_arg, $content);
            return $replace_shortcode;
        }

        public function perform_action_after_url_validated($id) {
            $get_post = get_post_status($id);
            $get_settings = get_option('cwginstock-unsub-settings');
            if ($get_post != 'cwg_unsubscribed') {
                $args = array(
                    'ID' => $id,
                    'post_type' => 'cwginstocknotifier',
                    'post_status' => 'cwg_unsubscribed',
                );
                $updated = wp_update_post($args);
                if ($updated) {
                    $email = get_post_meta($id, 'cwginstock_subscriber_email', true);
                    $message = $get_settings['success_message'];
                    $message = str_replace('{email_id}', $email, $message);
                    if (!isset($_GET['cwg_redirect_to'])) {
                        echo $message;
                    }
                    if (isset($_GET['cwg_redirect_to']) && $_GET['cwg_redirect_to'] != '') {
                        wc_add_notice("$message", 'success');
                        wp_redirect($_GET['cwg_redirect_to']);
                        exit;
                    }
                }
            } else {
                $email = get_post_meta($id, 'cwginstock_subscriber_email', true);
                $message = $get_settings['already_unsubscribed'];
                $message = str_replace('{email_id}', $email, $message);
                echo $message;
            }
        }

        public function set_forbidden_error() {
            $get_option = get_option('cwginstock-unsubscribe-settings');
            $get_settings = get_option('cwginstock-unsub-settings');
            $get_page = isset($get_option['page_id']) && $get_option['page_id'] != '' ? $get_option['page_id'] : false;
            $get_post_content = get_post_field('post_content', $get_page);
            if ($get_page && is_page($get_page) && has_shortcode($get_post_content, 'cwginstocknotifier_unsubscribe')) {
                if (!isset($_GET['id']) || !isset($_GET['hash'])) {
                    header("HTTP/1.1 401 Unauthorized");
                    $error_message = $get_settings['forbidden'];
                    wp_die($error_message);
                    exit;
                }
            }
        }

        public function register_settings() {
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsubscribe-settings');
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsub-settings');
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsub-endpoint');
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsub-menu-name');
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsub-page-heading');
            register_setting('cwginstocknotifier_settings', 'cwginstock-unsub-anchor-text');
            add_settings_section('cwginstock_section_unsubscribe', __('Unsubscribe Settings', 'cwginstocknotifier_unsubscribe'), array($this, 'section_heading'), 'cwginstocknotifier_settings');
            add_settings_field('cwg_instock_unsubscribe', __('Unsubscribe Page', 'cwginstocknotifier'), array($this, 'unsubscription_page'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_success', __('Unsubscribe Success Message', 'cwginstocknotifier_unsubscribe'), array($this, 'unsubscribe_success_message'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_already_unsubscribed', __('Already Unsubscribed Message', 'cwginstocknotifier_unsubscribe'), array($this, 'already_unsubscribed'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_forbidden', __('Direct Access 403 Error Message for Unsubscribe Page', 'cwginstocknotifier_unsubscribe'), array($this, 'forbidden_error_message'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_error_message', __('Unsubscribe Error Message', 'cwginstocknotifier_unsubscribe'), array($this, 'unsubscribe_error_message'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_endpoint', __('My Account Page Unsubscribe End point URL', 'cwginstocknotifier_unsubscribe'), array($this, 'unsubscribe_endpoint_url'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_endpoint_title', __('My Account Page Unsubscribe Menu Name', 'cwginstocknotifier_unsubscribe'), array($this, 'unsubscribe_endpoint_name'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_page_heading', __('My Account Subscribed List Page Heading', 'cwginstocknotifier_unsubscribe'), array($this, 'subscribed_list_page_heading'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
            add_settings_field('cwg_instock_unsubscribe_page_anchor_text', __('My Account Subscribed List Page Unsubscribe Link text', 'cwginstocknotifier_unsubscribe'), array($this, 'unsubscribe_link_text'), 'cwginstocknotifier_settings', 'cwginstock_section_unsubscribe');
        }

        public function section_heading() {
            _e('Use this shortcode <strong>{cwginstock_unsubscribe}</strong> in email message and it generates unsubscription url', 'cwginstocknotifier-unsubscribe');
        }

        public function unsubscription_page() {
            $option = get_option('cwginstock-unsubscribe-settings', array());
            $page_id = isset($option['page_id']) ? $option['page_id'] : '';
            $drop_down_args = array('name' => 'cwginstock-unsubscribe-settings[page_id]', 'selected' => $page_id);
            wp_dropdown_pages($drop_down_args);
            $get_post_content = get_post_field('post_content', $page_id);
            if (!has_shortcode($get_post_content, 'cwginstocknotifier_unsubscribe')) {
                $message = __('We unable to find this shortcode <strong>[cwginstocknotifier_unsubscribe]</strong> in the above selected page, so please create a new page/add this shortcode <strong>[cwginstocknotifier_unsubscribe]</strong> and then select your created page', 'cwginstocknotifier-unsubscribe');
                ?>
                <p><?php echo $message; ?></p>
                <?php
            } else {
                $error = __('We create the page upon activation of the plugin, By default your choosed page will be used for internal purpose and hence direct access return 403 forbidden error to avoid direct access', 'cwginstocknotifier-unsubscribe');
                echo "<p>$error</p>";
            }
        }

        public function unsubscribe_success_message() {
            $get_option = get_option('cwginstock-unsub-settings', array());
            ?>
            <textarea rows="5" cols="50" name="cwginstock-unsub-settings[success_message]"><?php echo $get_option['success_message']; ?></textarea>
            <?php
        }

        public function already_unsubscribed() {
            $get_option = get_option('cwginstock-unsub-settings', array());
            ?>
            <textarea rows="5" cols="50" name="cwginstock-unsub-settings[already_unsubscribed]"><?php echo $get_option['already_unsubscribed']; ?></textarea>
            <?php
        }

        public function forbidden_error_message() {
            $get_option = get_option('cwginstock-unsub-settings', array());
            ?>
            <textarea rows="5" cols="50" name="cwginstock-unsub-settings[forbidden]"><?php echo $get_option['forbidden']; ?></textarea>
            <?php
        }

        public function unsubscribe_error_message() {
            $get_option = get_option('cwginstock-unsub-settings', array());
            ?>
            <textarea rows="5" cols="50" name="cwginstock-unsub-settings[error_message]"><?php echo $get_option['error_message']; ?></textarea>
            <?php
        }

        public function unsubscribe_endpoint_url() {
            $value = get_option('cwginstock-unsub-endpoint', 'cwg-unsubscribe');
            ?>
            <input type="text" name="cwginstock-unsub-endpoint" value="<?php echo $value; ?>"/>
            <p><?php _e('This option is for My Account Endpoint URL, if you change anything other than default, please save settings and change the permalink(ex: default-> post name -> default) settings(just to flush rewrite rules to make the url work properly with your custom end point)', 'cwginstocknotifier_unsubscribe'); ?></p>
            <?php
        }

        public function unsubscribe_endpoint_name() {
            $value = get_option('cwginstock-unsub-menu-name', 'Subscribed List');
            ?>
            <input type="text" name="cwginstock-unsub-menu-name" value="<?php echo $value; ?>"/>
            <p><?php _e('This option is for My Account Tab Navigation Name(like Orders, Downloads etc) by default it will be Subscribed List', 'cwginstocknotifier_unsubscribe'); ?></p>
            <?php
        }

        public function subscribed_list_page_heading() {
            $value = get_option('cwginstock-unsub-page-heading', 'Your Subscribed List');
            ?>
            <input type="text" name="cwginstock-unsub-page-heading" value="<?php echo $value; ?>"/>
            <p><?php _e('This option is for Subscribed List Page Heading', 'cwginstocknotifier_unsubscribe'); ?></p>
            <?php
        }

        public function unsubscribe_link_text() {
            $value = get_option('cwginstock-unsub-anchor-text', 'Unsubscribe');
            ?>
            <input type="text" name="cwginstock-unsub-anchor-text" value="<?php echo $value; ?>"/>
            <p><?php _e('This option is for My Account Page Subscribed List - Unsubscribe Link Text', 'cwginstocknotifier_unsubscribe'); ?></p>
            <?php
        }

        public function default_values() {
            $get_option = get_option('cwginstock-unsub-settings', array());
            $get_option['success_message'] = __("Hello, Your email <mark>{email_id}</mark> has been successfully unsubscribed from our list", 'cwginstocknotifier_unsubscribe');
            $get_option["already_unsubscribed"] = __("Hello, Your email <mark>{email_id}</mark> has already unsubscribed from our list, you can resubscribe anytime from out of stock products", 'cwginstocknotifier_unsubscribe');
            $get_option["forbidden"] = __("You are not allowed to view this page as it is for internal purpose", 'cwginstocknotifier_unsubscribe');
            $get_option["error_message"] = __("Sorry we unable to validate your details, if you are existing member you can anytime unsubscribe from myaccount page", 'cwginstocknotifier_unsubscribe');
            add_option('cwginstock-unsub-settings', $get_option);

            add_option('cwginstock-unsub-menu-name', 'Subscribed List');
            add_option('cwginstock-unsub-page-heading', 'Your Subscribed List');
            add_option('cwginstock-unsub-anchor-text', 'Unsubscribe');
        }

        public function load_plugin_textdomain() {
            $domain = 'cwginstocknotifier_unsubscribe';
            $dir = untrailingslashit(WP_LANG_DIR);
            $locale = apply_filters('plugin_locale', get_locale(), $domain);
            if ($exists = load_textdomain($domain, $dir . '/plugins/' . $domain . '-' . $locale . '.mo')) {
                return $exists;
            } else {
                load_plugin_textdomain($domain, FALSE, basename(dirname(__FILE__)) . '/languages/');
            }
        }

    }

    new CWG_Instock_Notifier_Unsubscribe();
}