<?php
if (!class_exists('CWG_Instock_Unsubscribe_Myaccount')) {

    class CWG_Instock_Unsubscribe_Myaccount {

        /**
         * Custom endpoint name.
         *
         * @var string
         */
        public static $endpoint;

        /**
         * Plugin actions.
         */
        public function __construct() {

            self::$endpoint = get_option('cwginstock-unsub-endpoint', 'cwg-unsubscribe');
            // Actions used to insert a new endpoint in the WordPress.
            add_action('init', array($this, 'add_endpoints'));
            add_filter('query_vars', array($this, 'add_query_vars'), 0);
            // Change the My Accout page title.
            add_filter('the_title', array($this, 'endpoint_title'));
            // Insering your new tab/page into the My Account page.
            add_filter('woocommerce_account_menu_items', array($this, 'new_menu_items'));
            add_action('woocommerce_account_' . self::$endpoint . '_endpoint', array($this, 'endpoint_content'));
            //$this->install();
        }

        /**
         * Register new endpoint to use inside My Account page.
         *
         * @see https://developer.wordpress.org/reference/functions/add_rewrite_endpoint/
         */
        public function add_endpoints() {
            add_rewrite_endpoint(self::$endpoint, EP_ROOT | EP_PAGES);
        }

        /**
         * Add new query var.
         *
         * @param array $vars
         * @return array
         */
        public function add_query_vars($vars) {
            $vars[] = self::$endpoint;
            return $vars;
        }

        /**
         * Set endpoint title.
         *
         * @param string $title
         * @return string
         */
        public function endpoint_title($title) {
            global $wp_query;
            $is_endpoint = isset($wp_query->query_vars[self::$endpoint]);
            if ($is_endpoint && !is_admin() && is_main_query() && in_the_loop() && is_account_page()) {
                // New page title.

                $title = get_option('cwginstock-unsub-menu-name', 'Subscribed List');
                remove_filter('the_title', array($this, 'endpoint_title'));
            }
            return $title;
        }

        /**
         * Insert the new endpoint into the My Account menu.
         *
         * @param array $items
         * @return array
         */
        public function new_menu_items($items) {
            // Remove the logout menu item.
            $logout = $items['customer-logout'];
            unset($items['customer-logout']);
            $get_posts = $this->cwg_get_posts();

            if (is_array($get_posts) && !empty($get_posts)) {
                // Insert your custom endpoint.
                $items[self::$endpoint] = get_option('cwginstock-unsub-menu-name', 'Subscribed List');
            }
            // Insert back the logout item.
            $items['customer-logout'] = $logout;
            return $items;
        }

        public function cwg_get_posts() {
            $current_user_id = get_current_user_id();
            $args = array(
                'post_type' => 'cwginstocknotifier',
                'fields' => 'ids',
                'posts_per_page' => -1,
                'post_status' => 'cwg_subscribed',
                'meta_query' => array(
                    array(
                        'key' => 'cwginstock_user_id',
                        'value' => $current_user_id,
                        'compare' => '=',
                    )
                )
            );
            $get_posts = get_posts($args);
            return $get_posts;
        }

        /**
         * Endpoint HTML content.
         */
        public function endpoint_content() {

            $get_posts = $this->cwg_get_posts();
            ?>
            <h3><?php echo get_option('cwginstock-unsub-page-heading', 'Your Subscribed List'); ?></h3>
            <?php
            echo do_shortcode('[cwginstocknotifier_unsubscribe]');
            ?>
            <ol>
                <?php
                if (is_array($get_posts) && !empty($get_posts)) {
                    foreach ($get_posts as $each_id) {
                        $email_id = get_post_meta($each_id, 'cwginstock_subscriber_email', true);
                        $product_id = get_post_meta($each_id, 'cwginstock_product_id', true);
                        $get_option = get_option('cwginstock-unsubscribe-settings');
                        $permalink = get_permalink($product_id);
                        $md5_hash = md5($each_id . $email_id);
                        $unsubscribe_page_url = $_SERVER['REQUEST_URI'];
                        $query_arg = esc_url_raw(add_query_arg(array('id' => $each_id, 'hash' => $md5_hash, 'cwg_redirect_to' => $unsubscribe_page_url), $unsubscribe_page_url));
                        $get_product_name = new CWG_Instock_API();
                        $get_product_name = $get_product_name->display_product_name($each_id);
                        $product_link = "<a href='$permalink'>$get_product_name</a>";
                        $unsubscribe_text = get_option('cwginstock-unsub-anchor-text', 'Unsubscribe');
                        $unsubscribe_link = "<a href='$query_arg'>$unsubscribe_text</a>";
                        echo "<li>$product_link <br> ($email_id) --- $unsubscribe_link</li>";
                    }
                } else {
                    _e("No data found", 'cwginstocknotifier_unsubscribe');
                }
                ?>

            </ol>

            <?php
        }

        /**
         * Plugin install action.
         * Flush rewrite rules to make our custom endpoint available.
         */
        public static function install() {
            flush_rewrite_rules();
        }

    }

    new CWG_Instock_Unsubscribe_Myaccount();
}