<?php

if (!defined('ABSPATH')) {
    die("exit");
}
if (!class_exists('CWG_Mailchimp_API')) {

    class CWG_Mailchimp_API {

        private $api_key, $list_id;

        public function __construct($name = '', $email = '', $status = '', $api_key = false) {
            $get_option = get_option('cwginstock_mailchimp_settings');
            $is_enable = isset($get_option['enable_mailchimp']) ? $get_option['enable_mailchimp'] : false;
            if (!$is_enable && !$api_key) {
                return;
            }

            $api_key = isset($get_option['api_key']) ? $get_option['api_key'] : $api_key;
            if (!$api_key) {
                return;
            }

            $this->api_key = $api_key;
            $this->name = $name;
            $this->email = $email;
            $this->status = $status;
        }

        public function data_center() {
            $dc = substr($this->api_key, strpos($this->api_key, '-') + 1);
            return $dc;
        }

        public function get_list() {
            $body = array();
            $dc = $this->data_center();
            $url = 'https://' . $dc . '.api.mailchimp.com/3.0/lists/';
            $args = array(
                'headers' => array(
                    'Authorization' => 'Basic ' . base64_encode('user:' . $this->api_key)
                )
            );
            $response = wp_remote_get($url, $args);
            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response));
            }
            return $body;
        }

        public function add_subscriber() {
            $status = $this->status;
            $email = $this->email;
            $name = $this->name;

            $get_option = get_option('cwginstock_mailchimp_settings');
            $list_id = isset($get_option['sync_list']) ? $get_option['sync_list'] : false;
            if (!$list_id) {
                return;
            }
            $args = array(
                'method' => 'PUT',
                'headers' => array(
                    'Authorization' => 'Basic ' . base64_encode('user:' . $this->api_key)
                ),
                'body' => json_encode(array(
                    'email_address' => $email,
                    'status' => $status
                ))
            );

            $response = wp_remote_post('https://' . $this->data_center() . '.api.mailchimp.com/3.0/lists/' . $list_id . '/members/' . md5(strtolower($email)), $args);

            return $response;
        }

        public function batch_subscribers($subscribers) {
            $api_key = $this->api_key;
            $batch_operations = array();
            $dc = $this->data_center();
            $get_option = get_option('cwginstock_mailchimp_settings');
            $list_id = isset($get_option['sync_list']) ? $get_option['sync_list'] : false;
            if (!$list_id) {
                return;
            }

            $url = 'https://' . $dc . '.api.mailchimp.com/3.0/batches/';

            foreach ($subscribers as $subscriber) {

                $operation = array(
                    'method' => 'PUT',
                    'path' => 'lists/' . $list_id . '/members/' . md5(strtolower($subscriber['email_address'])),
                    'body' => json_encode($subscriber));

                array_push($batch_operations, $operation);
            }
            $args = array(
                'headers' => array(
                    'Authorization' => 'Basic ' . base64_encode('user:' . $api_key)
                ),
                'body' => json_encode(array('operations' => $batch_operations)),
            );

            $response = wp_remote_post($url, $args);

            return $response;
        }

    }

}