<?php

if (!defined('ABSPATH')) {
    die("exit");
}
if (!class_exists('CWG_Mailchimp_Actionscheduler')) {

    class CWG_Mailchimp_Actionscheduler {

        public function __construct() {
            register_activation_hook(CWGMAILCHIMP_FILE, array($this, 'register_schedule'));
            add_action('cwg_as_action_job_mailchimp', array($this, 'sync_list'));
        }

        public function register_schedule() {
            if (!as_next_scheduled_action('cwg_as_action_job_mailchimp')) {
                as_schedule_recurring_action(time(), 300, 'cwg_as_action_job_mailchimp');
            }
        }

        public function sync_list() {
            $args = array(
                'numberposts' => 10,
                'post_type' => 'cwginstocknotifier',
                'post_status' => array('cwg_subscribed', 'cwg_unsubscribed'),
                'order_by' => 'publish_date',
                'order' => 'ASC',
                'fields' => 'ids',
                'meta_query' => array(
                    array(
                        'key' => 'cwginstock_mailchimp_synched',
                        'compare' => 'NOT EXISTS'
                    ),
            ));
            $post_data = get_posts($args);
            $format_subscribers_mailchimp = array();
            if (is_array($post_data) && !empty($post_data)) {
                foreach ($post_data as $id) {
                    $name = get_post_meta($id, 'cwginstock_subscriber_name', true);
                    $email = get_post_meta($id, 'cwginstock_subscriber_email', true);
                    $status = str_replace('cwg_', '', get_post_status($id));
                    $format_subscribers_mailchimp[] = array(
                        'email_address' => $email,
                        'status' => $status,
                        'merge_fields' => array(
                            'FNAME' => $name,
                            'sid' => $id,
                        )
                    );
                    update_post_meta($id, 'cwginstock_mailchimp_synched', 'yes');
                }
                //mailchimp sync
                $mailchimp_obj = new CWG_Mailchimp_API();
                $response = $mailchimp_obj->batch_subscribers($format_subscribers_mailchimp);
            }
        }

    }

    new CWG_Mailchimp_Actionscheduler();
}