<?php
/*
 * Plugin Name: Add-on: Mailchimp - Back In Stock Notifier for WooCommerce
 * Description: This Add-on will helpful to sync subscribers from  Back InStock Notifier to Mailchimp
 * Author: codewoogeek
 * Plugin URI: https://codewoogeek.online/shop/back-instock-notifier/mailchimp/
 * Author URI: https://codewoogeek.online
 * Version: 1.0
 */
if (!defined('ABSPATH')) {
    die("exit");
}
if (!class_exists('CWG_Instock_Mailchimp')) {

    class CWG_Instock_Mailchimp {

        public function __construct() {
            $this->define_constant();
            $this->include_files();
            add_action('admin_init', array($this, 'register_manage_settings'));
            add_action('wp_ajax_cwg_mailchimp_ajax_verify', array($this, 'perform_ajax_verify'));
            add_action('cwginstock_after_insert_subscriber', array($this, 'sync_email_to_mailchimp'), 10, 2);
            add_filter('cwginstocknotifier_columns', array($this, 'add_column'), 999, 1);
            add_action('cwginstock_custom_columns', array($this, 'manage_column'), 10, 2);
            add_action('transition_post_status', array($this, 'mailchimp_status_check'), 10, 3);
        }

        public function include_files() {
            include('includes/class-mailchimp-api.php');
            include('includes/class-action-scheduler.php');
        }

        public function define_constant() {
            $this->define('CWGMAILCHIMP_FILE', __FILE__);
        }

        private function define($name, $value) {
            if (!defined($name)) {
                define($name, $value);
            }
        }

        public function register_manage_settings() {
            register_setting('cwginstocknotifier_settings', 'cwginstock_mailchimp_settings');
            add_settings_section('cwg_mailchimp', __('Mailchimp Settings', 'cwginstocknotifier-mailchimp'), array($this, 'section_headings'), 'cwginstocknotifier_settings');
            add_settings_field('cwg_mailchimp_enable', __('Sync Email to Mailchimp', 'cwginstocknotifier-mailchimp'), array($this, 'enable_mailchimp'), 'cwginstocknotifier_settings', 'cwg_mailchimp');
            add_settings_field('cwg_mailchimp_api', __('Mailchimp API Key', 'cwginstocknotifier-mailchimp'), array($this, 'api_textbox'), 'cwginstocknotifier_settings', 'cwg_mailchimp');
            add_settings_field('cwg_sync_email', __('Choose Sync Email List', 'cwginstocknotifier-mailchimp'), array($this, 'sync_email_dropdown'), 'cwginstocknotifier_settings', 'cwg_mailchimp');
        }

        public function section_headings() {
            _e("Enable Mailchimp in Back In Stock Notifier", 'cwginstocknotifier-mailchimp');
        }

        public function enable_mailchimp() {
            $options = get_option('cwginstock_mailchimp_settings');
            ?>
            <input type='checkbox' name='cwginstock_mailchimp_settings[enable_mailchimp]' <?php isset($options['enable_mailchimp']) ? checked($options['enable_mailchimp'], 1) : ''; ?> value="1"/>
            <?php
        }

        public function perform_ajax_verify() {
            $fetch_lists_array = array();
            if (isset($_POST['security']) && $_POST['security'] != '') {
                if (wp_verify_nonce($_POST['security'], 'cwg_mailchimp_security')) {
                    $get_api_key = isset($_POST['api_key']) && $_POST['api_key'] ? $_POST['api_key'] : '';
                    if ($get_api_key) {
                        $mailchimp_obj = new CWG_Mailchimp_API($name = '', $email = '', $status = '', $get_api_key);
                        $get_lists = $mailchimp_obj->get_list();
                        if (isset($get_lists->lists)) {
                            $get_lists = $get_lists->lists;
                            if (is_array($get_lists) && !empty($get_lists)) {
                                foreach ($get_lists as $each_list) {
                                    $fetch_lists_array[$each_list->id] = $each_list->name;
                                }
                            }
                        }
                    }


                    update_option('cwginstock_mailchimp_get_lists', $fetch_lists_array);
                }
            }
            die();
        }

        public function api_textbox() {
            $options = get_option('cwginstock_mailchimp_settings');
            $security = wp_create_nonce('cwg_mailchimp_security');
            $ajax_url = admin_url('admin-ajax.php');
            ?>
            <input type='text' style='width: 400px;' class="cwg_mailchimp_api_key" name='cwginstock_mailchimp_settings[api_key]' value="<?php echo isset($options['api_key']) && $options['api_key'] != '' ? $options['api_key'] : ''; ?>"/>
            <a href="#" class="cwg_mailchimp_verify">Verify API & Fetch List</a>
            <div class="cwginstock_mailchimp_settings_msg"></div>

            <script type="text/javascript">
                jQuery(function () {
                    jQuery('.cwg_mailchimp_verify').on('click', function () {
                        //verify  
                        var get_api_key = jQuery('.cwg_mailchimp_api_key').val();
                        alert(get_api_key);
                        jQuery('.cwginstock_mailchimp_settings_msg').html("Verify API under progress, settings will be automatically saved upon success");
                        jQuery('.cwginstock_mailchimp_settings_msg').css('color', 'green');
                        var data = {
                            action: 'cwg_mailchimp_ajax_verify',
                            api_key: get_api_key,
                            security: '<?php echo $security; ?>',
                        };
                        jQuery.ajax({
                            type: "post",
                            url: "<?php echo $ajax_url; ?>",
                            data: data,
                            success: function (msg) {
                                jQuery('.button-primary').trigger('click');
                            },
                            error: function (request, status, error) {
                                jQuery('.cwginstock_mailchimp_settings_msg').html("Unable to verify your api details, please cross check if api key is valid");
                            }
                        });
                        return false;
                    });
                });
            </script>
            <?php
        }

        public function sync_email_dropdown() {
            $get_update = get_option('cwginstock_mailchimp_get_lists');
            $get_select_datas = is_array($get_update) && !empty($get_update) ? $get_update : '';
            ?>
            <?php
            if ($get_select_datas) {
                $get_option = get_option('cwginstock_mailchimp_settings');
                ?>
                <select name="cwginstock_mailchimp_settings[sync_list]">
                    <option value=''><?php _e('Select List', 'cwginstocknotifier-mailchimp'); ?></option>
                    <?php
                    foreach ($get_select_datas as $list_id => $list_name) {
                        $saved_list = isset($get_option['sync_list']) && $get_option['sync_list'] != '' && $list_id == $get_option['sync_list'] ? 'selected=selected' : '';
                        ?>
                        <option value="<?php echo $list_id; ?>" <?php echo $saved_list; ?>><?php echo $list_name; ?></option>
                        <?php
                    }
                    ?>
                </select>
                <?php
            }
        }

        public function unsubscribe_mailchimp() {
            $options = get_option('cwginstock_mailchimp_settings');
            ?>
            <input type='checkbox' name='cwginstock_mailchimp_settings[sync_mailchimp]' <?php isset($options['sync_mailchimp']) ? checked($options['sync_mailchimp'], 1) : ''; ?> value="1"/>
            <?php
        }

        public function sync_email_to_mailchimp($id, $post_data) {
            $subscriber_name = isset($post_data['subscriber_name']) ? $post_data['subscriber_name'] : '';
            $email = isset($post_data['user_email']) ? $post_data['user_email'] : '';
            $mailchimp_obj = new CWG_Mailchimp_API($subscriber_name, $email, 'subscribed');
            $response = $mailchimp_obj->add_subscriber();
            if (!is_wp_error($response)) {
                update_post_meta($id, 'cwginstock_mailchimp_synched', 'yes');
            }
        }

        public function add_column($columns) {
            $date = $columns['date'];
            unset($columns['date']);
            $columns['mailchimpstatus'] = __('Mailchimp Synced', 'cwginstocknotifier');
            $columns['date'] = $date;
            return $columns;
        }

        public function manage_column($column, $post_id) {
            if ($column == 'mailchimpstatus') {
                $mailchimp_synched = get_post_meta($post_id, 'cwginstock_mailchimp_synched', true);
                echo $mailchimp_synched == 'yes' ? 'YES' : 'NO';
            }
        }

        public function mailchimp_status_check($new, $old, $post) {
            if (($new == 'cwg_unsubscribed' && $old == 'cwg_subscribed') || ($new == 'cwg_subscribed' && $old == 'cwg_unsubscribed')) {
                delete_post_meta($post->ID, 'cwginstock_mailchimp_synched');
            }
        }

    }

    new CWG_Instock_Mailchimp();
}