<?php

/*
 * Plugin Name: Add-on: Track Sales - Back In Stock Notifier for WooCommerce
 * Description: Track Sales Add-on for Back In Stock Notifier
 * Author: codewoogeek
 * Plugin URI: https://codewoogeek.online/shop/back-instock-notifier/track-sales/
 * Author URI: https://codewoogeek.online
 * Version: 1.0
 */

if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('CWG_Tracking_URL')) {

    class CWG_Tracking_URL {

        public function __construct() {
            add_filter('cwginstock_cart_link', array($this, 'cwg_add_tracking_info'), 10, 3);
            add_action('wp', array($this, 'cwg_retrive_tracking_info'));
            add_action('woocommerce_new_order', array($this, 'cwg_save_order'));
            add_action('woocommerce_order_status_changed', array($this, 'cwginstock_change_converted'), 10, 4);
        }

        public function cwg_add_tracking_info($cart_url, $product_id, $subscriber_id) {
            $query_args = array(
                'subscriber_id' => $subscriber_id,
                'hash' => md5($subscriber_id . "_" . $product_id),
            );
            $cart_url = esc_url_raw(add_query_arg($query_args, $cart_url));
            return $cart_url;
        }

        public function cwg_retrive_tracking_info() {
            try {
                if (isset($_REQUEST['subscriber_id']) && isset($_REQUEST['hash']) && isset($_REQUEST['add-to-cart'])) {
                    $product_id = isset($_REQUEST['variation_id']) && !empty($_REQUEST['variation_id']) ? $_REQUEST['variation_id'] : $_REQUEST['add-to-cart'];
                    $subscriber_id = $_REQUEST['subscriber_id'];
                    $hash_key = $_REQUEST['hash'];
                    $md5_request = md5($subscriber_id . "_" . $product_id);
                    if ($hash_key == $md5_request) {
                        $request_data = array($subscriber_id);
                        $get_session = WC()->session->get('subscriber_id');
                        if ($get_session) {
                            $merge_data = is_array($get_session) && !empty($get_session) ? array_merge($get_session, $request_data) : $request_data;
                        } else {
                            $merge_data = $request_data;
                        }
                        $merge_data = array_unique($merge_data);
                        WC()->session->set('subscriber_id', $merge_data);
                    }
                }
            } catch (Exception $ex) {
                
            }
        }

        public function cwg_save_order($order_id) {
            $session = WC()->session->get('subscriber_id');
            if ($session) {
                update_post_meta($order_id, 'subscriber_id', $session);
            }
        }

        public function cwginstock_change_converted($order_id, $old_status, $new_status, $order) {
            if ($new_status == 'completed' || $new_status == 'wc-completed' || $new_status == 'processing' || $new_status == 'wc-processing') {
                $get_subscriber_id = get_post_meta($order_id, 'subscriber_id', true);
                if ($get_subscriber_id) {
                    $items = $order->get_items();
                    $pids = array();
                    foreach ($items as $item) {
                        $product_id = $item->get_product_id();
                        $product_variation_id = $item->get_variation_id();
                        $pids[] = $product_variation_id > 0 ? $product_variation_id : $product_id;
                    }
                    if (is_array($get_subscriber_id) && !empty($get_subscriber_id)) {
                        foreach ($get_subscriber_id as $each_id) {
                            $sub_pid = get_post_meta($each_id, 'cwginstock_pid', true);
                            if (in_array($sub_pid, $pids)) {

                                if ('trash' != get_post_status($each_id)) {
                                    $obj = new CWG_Instock_API();
                                    $obj->update_subscriber($each_id, 'cwg_converted');
                                }
                            }
                        }
                    }
                }
            }
        }

    }

    new CWG_Tracking_URL();
}
