<?php

require_once dirname(__FILE__) . '/library/api/paymentmethods/giropay/giropay.php';

/**
 * @package Buckaroo
 */
class WC_Gateway_Buckaroo_Giropay extends WC_Gateway_Buckaroo
{
    const PAYMENT_CLASS = BuckarooGiropay::class;
    public function __construct()
    {
        $this->id                     = 'buckaroo_giropay';
        $this->title                  = 'Giropay';
        $this->has_fields             = true;
        $this->method_title           = "Buckaroo Giropay";
        $this->setIcon('24x24/giropay.gif', 'svg/Giropay.svg');
        $this->addRefundSupport();

        parent::__construct();

    }

    /**
     * Can the order be refunded
     * @param integer $order_id
     * @param integer $amount defaults to null
     * @param string $reason
     * @return callable|string function or error
     */
    public function process_refund($order_id, $amount = null, $reason = '')
    {
        return $this->processDefaultRefund($order_id, $amount, $reason);
    }

    /**
     * Validate payment fields on the frontend.
     *
     * @return bool
     */
    public function validate_fields()
    {
        if ($this->request('buckaroo-giropay-bancaccount') === null) {
            wc_add_notice(__('Please provide correct BIC', 'wc-buckaroo-bpe-gateway'), 'error');
        }
        
        parent::validate_fields();
    }

    /**
     * Process payment
     *
     * @param integer $order_id
     * @return callable fn_buckaroo_process_response()
     */
    public function process_payment($order_id)
    {
        $order = getWCOrder($order_id);
        /** @var BuckarooGiropay */
        $giropay = $this->createDebitRequest($order);
        $giropay->bic         = $this->request('buckaroo-giropay-bancaccount');
        $response = $giropay->Pay();
        return fn_buckaroo_process_response($this, $response);
    }
}
