<?php

namespace pCon;

defined( 'ABSPATH' ) || exit;

class_exists( 'pCon\pConIframe' ) || exit;

class pConIframe {

	/**
	 * Load woocommerce in rest api
	 *
	 * @return void
	 */
	public function rest_api_includes(): void {
		require_once( WC_ABSPATH . 'includes/wc-cart-functions.php' );
		require_once( WC_ABSPATH . 'includes/wc-notice-functions.php' );
	}

	/**
	 * Register webhook
	 *
	 * @return void
	 */
	public function create_webhook_endpoint(): void {
		register_rest_route( 'pcon/v1', '/add-to-cart/(?P<product_id>\d+)', [
			'methods'  => [ 'GET', 'POST' ],
			'callback' => [ $this, 'handle_webhook_request' ],
		] );
	}

	/**
	 * Webhook callback
	 *
	 * @param $request
	 *
	 * @return void
	 */
	public function handle_webhook_request( $request ): void {

		$product_id = $request->get_param( 'product_id' );
		$user_id    = $request->get_param( 'user_id' );
		$session    = $request->get_param( 'session' );
		if ( ! $product_id ) {
			echo 'No product id set';
			wp_die();
		}

		if ( ! $user_id && ! $session ) {
			echo 'No user found';
			wp_die();
		}

		$get_params = $request->get_params();

		$quantity  = $get_params['NEW_ITEM-QUANTITY'][1] ?? 1;
		$price     = $get_params['NEW_ITEM-PRICE'][1] ?? 0;
		$VENDORMAT = $get_params['NEW_ITEM-VENDORMAT'][1] ?? 0;
		$VARCODE   = $get_params['NEW_ITEM-EGR_CUSTOMDATA_VARCODE'][1] ?? 0;

		if ( $user_id ) {
			// Log user in.
			wp_set_current_user( $user_id );
			wp_set_auth_cookie( $user_id );
		} else {
			// Set session cookies if user is not logged in.
			setcookie( 'wp_woocommerce_session_' . COOKIEHASH, $session, time() + 60 * 60 * 24 * 2, '/', '', false, true );
			$_COOKIE[ 'wp_woocommerce_session_' . COOKIEHASH ] = $session;
		}

		// Initialize cart.
		$woocommerce          = WC();
		$woocommerce->session = new \WC_Session_Handler();
		$woocommerce->session->init();
		$woocommerce->customer = new \WC_Customer();
		$woocommerce->cart     = new \WC_Cart();

		// Check if product is already in cart.
		$in_cart    = false;
		$cart_items = $woocommerce->cart->get_cart();
		foreach ( $cart_items as $cart_item ) {
			if ( $cart_item['product_id'] == $product_id && $VENDORMAT == $cart_item['VENDORMAT'] && $VARCODE == $cart_item['VARCODE'] ) {
				$in_cart = $cart_item;
				break;
			}
		}
		$in_cart = false;
		if ( $in_cart ) {
			$woocommerce->cart->set_quantity( $in_cart['key'], $in_cart['quantity'] + $quantity );
		} else {
			$image_url = $get_params['NEW_ITEM-ATTACHMENT'][1] ?? ''; // TBD
			$type      = pathinfo( $image_url, PATHINFO_EXTENSION );
			$data      = file_get_contents( $image_url );
			$base64    = 'data:image/' . $type . ';base64,' . base64_encode( $data );

			$cart_item_data = [
				'custom_image_url' => $base64,
				'VENDORMAT'        => $VENDORMAT,
				'VARCODE'          => $VARCODE,
				'new_price'        => $price,
				'custom_title'     => $get_params['NEW_ITEM-DESCRIPTION'][1],
				'custom_data'      => $get_params['NEW_ITEM-EGR_CUSTOMDATA_FEATURETEXT'][1],

				'product_id' => $product_id,
				'quantity'   => $quantity,
			];
//			$woocommerce->cart->add_to_cart( $product_id, intval( $quantity ), 0, [], $cart_item_data );

			$ajax_add_to_quote = new \AF_R_F_Q_Quote();
			$ajax_add_to_quote->add_to_quote( $cart_item_data, $product_id, $quantity, 0, array(), $cart_item_data );
		}

		wp_redirect( $get_params['NEW_ITEM-EGR_CUSTOMDATA_REOPEN_URL'][1] );
	}

	/**
	 * Show pcon iframe
	 *
	 * @param $atts
	 *
	 * @return string
	 */
	public function pcon_iframe( $atts ): string {

		$atts = shortcode_atts( [
			'post_id' => get_the_ID(),
		], $atts );

		$iframe   = '';
		$pcon_url = get_field( 'pcon_url', $atts['post_id'] );

		if ( empty( $pcon_url ) ) {
			return $iframe;
		}

		$this->load_custom_form_script();

		// Get cookie.
		$user_id  = get_current_user_id();
		$site_url = get_bloginfo( 'url' );
		if ( ! $user_id ) {
			WC()->session->set_customer_session_cookie( true );
			$session       = $_COOKIE[ 'wp_woocommerce_session_' . COOKIEHASH ];
			$webhook_url   = $site_url . '/wp-json/pcon/v1/add-to-cart/' . $atts['post_id'] . '?session=' . $session;
			$custom_fields = "0___" . $atts['post_id'];
		} else {
			$webhook_url   = $site_url . '/wp-json/pcon/v1/add-to-cart/' . $atts['post_id'] . '?user_id=' . $user_id;
			$custom_fields = $user_id . "___" . $atts['post_id'];;
		}

		$iframe .= '<iframe id="pcon-iframe" class="pcon-iframe" src="' . $pcon_url . '&HOOK_URL=' . $webhook_url . '&customFields=' . $custom_fields . '&ltt=true" width="100%"></iframe>';

		return $iframe;

	}

	/**
	 * Load custom form scripts
	 *
	 * @return void
	 */
	private function load_custom_form_script(): void {
		wp_enqueue_script( 'pcon-scripts', plugins_url() . '/' . plugin_basename( __DIR__ ) . '/../assets/scripts.js', [], PCON_VERSION );
		wp_enqueue_style( 'pcon-style', plugins_url() . '/' . plugin_basename( __DIR__ ) . '/../assets/style.css', [], PCON_VERSION );
	}

}
