<?php

namespace pCon;

defined( 'ABSPATH' ) || exit;

class_exists( 'pCon\pCon' ) || exit;

class pCon {

	/**fi
	 * Loader instance.
	 *
	 * @var pConLoader $loader Instance of this class.
	 */
	protected pConLoader $loader;

	/**
	 * pCon constructor.
	 */
	public function __construct() {
		$this->loader = new pConLoader();

		$this->define_iframe();
		$this->define_woocommerce();
	}

	/**
	 * Define the pcon iframe functionality.
	 *
	 * @return void
	 */
	private function define_iframe(): void {
		$pcon_iframe = new pConIframe();

		$this->loader->add_shortcode( 'pcon_iframe', $pcon_iframe, 'pcon_iframe' );

		$this->loader->add_action( 'rest_api_init', $pcon_iframe, 'create_webhook_endpoint' );
		$this->loader->add_action( 'wp_loaded', $pcon_iframe, 'rest_api_includes' );
	}

	/**
	 * Define the pcon woocommerce functionality.
	 *
	 * @return void
	 */
	public function define_woocommerce(): void {
		$pcon_woocommerce = new pConWooCommerce();

		$this->loader->add_filter( 'kses_allowed_protocols', $pcon_woocommerce, 'allow_data' );
		$this->loader->add_filter( 'addify_quote_item_thumbnail', $pcon_woocommerce, 'custom_cart_item_thumbnail', 10, 3 );
		$this->loader->add_filter( 'addify_quote_item_name', $pcon_woocommerce, 'dynamic_cart_item_title', 10, 2 );
		$this->loader->add_filter( 'addify_rfq_order_item_name', $pcon_woocommerce, 'dynamic_cart_item_title', 10, 2 );
		$this->loader->add_action( 'woocommerce_admin_order_item_thumbnail', $pcon_woocommerce, 'custom_order_item_thumbnail', 10, 3 );
		$this->loader->add_action( 'woocommerce_before_calculate_totals', $pcon_woocommerce, 'update_cart_totals', 10, 0 );
		$this->loader->add_action( 'woocommerce_cart_item_data', $pcon_woocommerce, 'modify_cart_item_price', 10, 2 );
		$this->loader->add_action( 'woocommerce_set_cookie_options', $pcon_woocommerce, 'set_cookie_options_filter', 10, 3 );

		$this->loader->add_action( 'wp_ajax_cart_count_retriever', $pcon_woocommerce, 'cart_count_retriever' );
		$this->loader->add_action( 'wp_ajax_nopriv_cart_count_retriever', $pcon_woocommerce, 'cart_count_retriever' );

		$this->loader->add_action( 'woocommerce_order_item_name', $pcon_woocommerce, 'display_product_image_in_order_item', 20, 2 );
		$this->loader->add_action( 'woocommerce_checkout_create_order_line_item', $pcon_woocommerce, 'save_image_order_item_meta', 10, 4 );
		$this->loader->add_action( 'woocommerce_hidden_order_itemmeta', $pcon_woocommerce, 'hide_custom_meta_order_and_thank_you_page' );
		$this->loader->add_action( 'woocommerce_order_item_get_formatted_meta_data', $pcon_woocommerce, 'hide_meta_order_received_page' );

		$this->loader->add_action( 'woocommerce_cart_item_name', $pcon_woocommerce, 'dynamic_cart_item_title', 1, 2 );
		$this->loader->add_action( 'woocommerce_cart_item_price', $pcon_woocommerce, 'dynamic_cart_item_price', 10, 2 );

		$this->loader->add_action( 'woocommerce_before_order_itemmeta', $pcon_woocommerce, 'change_admin_product_title', 10, 2 );

		$this->loader->add_action( 'woocommerce_after_single_product_summary', $pcon_woocommerce, 'pcon_add_iframe', 10, 2 );
    }

	/**
	 * Run the loader to execute all the hooks with WordPress.
	 *
	 * @return void
	 */
	public function run(): void {
		$this->loader->run();
	}

}
