<?php

// Set headers to allow pcon to call this file
header( "Access-Control-Allow-Headers: Content-Type" );
header( "Access-Control-Allow-Method: POST" );
header( "Access-Control-Allow-Origin: https://ui.pcon-solutions.com" );

// Load WordPress
include($_SERVER['DOCUMENT_ROOT'].'/wp/wp-load.php');

// Get the request payload
$request_payload = file_get_contents( 'php://input' );
$data            = json_decode( $request_payload, true );

$item_price = 0;
$basked_id  = 0;
if ( ! empty( $data ) ) {
	$obx_url = $data['obxUrl'];

	// Read obxUrl which is a xml type file and get the price.
	$obx_xml = file_get_contents( $obx_url );
	$obx_xml = simplexml_load_string( $obx_xml );

	// Make sure all the items exist in $obxXml.
	if ( ! empty( $obx_xml->items->bskArticle->itemPrice->attributes()->value ) ) {
		$item_price = $obx_xml->items->bskArticle->itemPrice->attributes()->value->__toString();
		$basked_id  = $obx_xml->items->bskArticle->attributes()->basketId->__toString();
	}
}

// Get the custom fields.
if ( ! empty( $data['customFields'] ) ) {
	$custom_fields = explode( "___", $data['customFields'] );
	$user_id       = $custom_fields[0];
	$product_id    = $custom_fields[1];

	if ( ! empty( $user_id ) ) {
		// Check if user has specific role.
		$user = get_user_by( 'id', $user_id );
		if ( ! empty( $user ) && in_array( 'reseller', (array) $user->roles ) ) {
			$discount_rate = 25;
		}

		// Remove discount rate from item price.
		if ( ! empty( $discount_rate ) ) {
			$item_price = $item_price - ( $item_price * ( $discount_rate / 100 ) );
		}
	}
}

// Create response json.
$json = array(
	"currency" => "EUR",
	"articles" => array(
		array(
			"basketId"   => $basked_id,
			"salesPrice" => $item_price,
		),
	),
);

// Return json.
echo json_encode( $json );
exit;
