<?php

namespace pCon;

defined( 'ABSPATH' ) || exit;

class_exists( 'pCon\pConWooCommerce' ) || exit;

class pConWooCommerce {

	/**
	 * Update title backend
	 *
	 * @param $item_id int Item id
	 *
	 * @return void
	 */
	public function change_admin_product_title( int $item_id ): void {
		if ( $item_id ) {
			echo $item['custom_title'] ?? '';
			echo "<style>.item[data-order_item_id='$item_id'] .wc-order-item-name{display:none}</style>";
		}
	}

	/**
	 * Custom order item image
	 *
	 * @param $product_image string Product image
	 * @param $item_id Item id
	 * @param $item array Item
	 *
	 * @return string
	 */
	public function custom_order_item_thumbnail( string $product_image, $item_id, array $item ): string {
		$custom_image_url = $item['custom_image_url'] ?? '';
		if ( $custom_image_url ) {
			$product_image = ' <img src="' . $custom_image_url . '"> ';
		}

		return $product_image;
	}

	/**
	 * Custom cart item title
	 *
	 * @param $product_name string Product name
	 * @param $cart_item array Cart item
	 *
	 * @return string
	 */
	public function dynamic_cart_item_title( string $product_name, array $cart_item ): string {
		if ( ! empty( $cart_item['custom_title'] ) ) {
			return '<a href="">' . $cart_item['custom_title'] . '</a><br><span style="font-weight: 300 !important">' . nl2br( $cart_item['custom_data'] ) . '</span>';
		} else {
			return $product_name;
		}
	}

	/**
	 * Custom cart item price
	 *
	 * @param $product_price string Product price
	 * @param $cart_item array Cart item
	 *
	 * @return string
	 */
	public function dynamic_cart_item_price( string $product_price, array $cart_item ): string {
		if ( ! empty( $cart_item['new_price'] ) ) {
			return wc_price( $cart_item['new_price'] );
		} else {
			return $product_price;
		}
	}

	/**
	 * Set custom image
	 *
	 * @param $item_name string Item name
	 * @param $item array Item data
	 *
	 * @return string
	 */
	public function display_product_image_in_order_item( string $item_name, array $item ): string {
		if ( $custom_image_url = $item->get_meta( 'custom_image_url' ) ) {
			$custom_title = $item->get_meta( 'custom_title' );
			if ( empty( $custom_title ) ) {
				$custom_title = $item_name;
			}
			$item_name = ' <img src="' . $custom_image_url . '" width="100" height="100" />' . $custom_title;
		}

		return $item_name;
	}

	/**
	 * Save custom_image_url to order item meta
	 *
	 * @param $item object WC_Order_Item_Product
	 * @param $cart_item_key string Cart item key
	 * @param $values array Cart item values
	 *
	 * @return void
	 */
	public function save_image_order_item_meta( object $item, string $cart_item_key, array $values ): void {
		if ( isset( $values['VARCODE'] ) ) {
			$item->add_meta_data( 'VARCODE', $values['VARCODE'], true );
		}
		if ( isset( $values['custom_image_url'] ) ) {
			$item->add_meta_data( 'custom_image_url', $values['custom_image_url'], true );
		}
		if ( isset( $values['custom_title'] ) ) {
			$item->add_meta_data( 'custom_title', $values['custom_title'], true );
		}
		if ( isset( $values['custom_data'] ) ) {
			$item->add_meta_data( 'custom_data', $values['custom_data'], true );
		}
	}

	/**
	 * Hide custom meta from order and thank you page
	 *
	 * @param $hidden array Hidden meta
	 *
	 * @return array array
	 */
	public function hide_custom_meta_order_and_thank_you_page( array $hidden ): array {
		if ( is_admin() ) {
			return $hidden;
		}

		$hidden[] = 'VARCODE';
		$hidden[] = 'custom_image_url';
		$hidden[] = 'custom_title';

		return $hidden;
	}

	/**
	 * Hide custom meta from order received page
	 *
	 * @param $formatted_meta array Formatted meta
	 *
	 * @return array
	 */
	public function hide_meta_order_received_page( array $formatted_meta ): array {
		foreach ( $formatted_meta as $key => $meta ) {
			if ( is_admin() ) {
				if ( $meta->key === 'custom_image_url' || $meta->key === 'custom_title' ) {
					unset( $formatted_meta[ $key ] );
				}
			} else {
				if ( $meta->key === 'custom_image_url' || $meta->key === 'VARCODE' || $meta->key === 'custom_title' ) {
					unset( $formatted_meta[ $key ] );
				}
			}
		}

		return $formatted_meta;
	}

	/**
	 * Ajax callback to retrieve cart count
	 *
	 * @return void
	 */
	public function cart_count_retriever(): void {
		global $wpdb;

		// Return json with cart count and cart url.
		echo json_encode( array(
			'cart_count' => count( WC()->session->get( 'quotes' ) ?? 0 ),
			'cart_url'   => esc_url( get_page_link( get_option( 'addify_atq_page_id' ) ) )
		) );
		wp_die();
	}

	/**
	 * Set cookie in php cookie variable, so it can be used later
	 *
	 * @param $cookie_options array Cookie options
	 * @param $name string Cookie name
	 * @param $value string Cookie value
	 *
	 * @return array
	 */
	public function set_cookie_options_filter( array $cookie_options, string $name, string $value ): array {
		if ( empty( $_COOKIE[ $name ] ) ) {
			$_COOKIE[ $name ] = $value;
		}

		return $cookie_options;
	}

	/**
	 * Modify cart item price
	 *
	 * @param $cart_item_data array Cart item data
	 *
	 * @return array
	 */
	public function modify_cart_item_price( array $cart_item_data ): array {
		if ( isset( $cart_item_data['new_price'] ) ) {
			$new_price = floatval( $cart_item_data['new_price'] );
			$cart_item_data['data']->set_price( $new_price );
		}

		return $cart_item_data;
	}

	/**
	 * Update cart totals
	 *
	 * @return void
	 */
	public function update_cart_totals(): void {
		foreach ( WC()->cart->get_cart() as $cart_item ) {
			if ( isset( $cart_item['new_price'] ) ) {
				$new_price = floatval( $cart_item['new_price'] );
				$cart_item['data']->set_price( $new_price );
			}
		}
	}

	/**
	 * Load custom image on cart
	 *
	 * @param $thumbnail string Thumbnail
	 * @param $cart_item array Cart item
	 *
	 * @return string
	 */
	public function custom_cart_item_thumbnail( string $thumbnail, array $cart_item ): string {
		$custom_image_url = $cart_item['custom_image_url'] ?? '';
		if ( $custom_image_url ) {
			$thumbnail = ' <img src="' . $custom_image_url . '"> ';
		}

		return $thumbnail;
	}

	/**
	 * Show pcon iframe after summary
	 *
	 * @return void
	 */
	public function pcon_add_iframe(): void {
		echo do_shortcode( '[pcon_iframe]' );
	}

	/**
	 * Allow data protocol
	 *
	 * @param array $protocols
	 *
	 * @return array
	 */
	public function allow_data( array $protocols ): array {
		$protocols[] = 'data';

		return $protocols;
	}

}
