document.addEventListener("DOMContentLoaded", function () {

    $ = jQuery;

    const iframe = $(".pcon-iframe");
    let refreshed = 0;
    iframe.on("load", function () {
        if (refreshed >= 1) {
            // Update cart count
            const data = {
                'action': 'cart_count_retriever'
            }
            $.post(woocommerce_params.ajax_url, data, function (response) {
                // Make response json usable
                response = JSON.parse(response);

                // Update cart count
                $('#total-items-count').html(response.cart_count);

                // Show success message
                iframe.before('<div class="woocommerce-message" role="alert" style="background: #d1beb0; color: #fff">' +
                    '<a href="' + response.cart_url + '" class="button wc-forward" style="background: #c25400;margin:15px;">Bekijk offerte</a> ' +
                    'Product succesvol toegevoegd aan je offerte. ' +
                    '</div>');

                setTimeout(function () {
                    $('.woocommerce-message').remove();
                }, 2500);
            });

        } else {
            refreshed++;
        }
    })

});