<?php

namespace ACA\Types;

use AC;
use AC\PluginInformation;
use AC\Registrable;
use ACA\Types\Service;

final class Types extends AC\Plugin {

	public function __construct( $file, AC\Plugin\Version $version ) {
		parent::__construct( $file, $version );
	}

	public function register() {
		if ( ! $this->load_types_api() ) {
			return;
		}

		$plugin_information = new PluginInformation( $this->get_basename() );
		$setup_factory = new AC\Plugin\SetupFactory( 'aca_types_version', $this->get_version() );

		$services = [
			new Service\Columns(),
			new Service\Scripts( $this->get_location() ),
			new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::SITE ) ),
		];

		if ( $plugin_information->is_network_active() ) {
			$services[] = new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::NETWORK ) );
		}

		array_map( [ $this, 'register_service' ], $services );
	}

	private function register_service( $service ) {
		if ( $service instanceof Registrable ) {
			$service->register();
		}
	}

	/**
	 * Load Types API functions
	 * @return bool
	 */
	private function load_types_api() {
		if ( ! defined( 'WPCF_EMBEDDED_TOOLSET_ABSPATH' ) ) {
			return false;
		}

		$calls = [
			WPCF_EMBEDDED_TOOLSET_ABSPATH . '/types/embedded/frontend.php'        => [
				'types_render_termmeta',
				'types_render_field',
				'types_render_usermeta',
			],
			WPCF_EMBEDDED_TOOLSET_ABSPATH . '/types/embedded/includes/fields.php' => [
				'wpcf_admin_fields_get_fields_by_group',
				'wpcf_admin_fields_get_field',
				'wpcf_admin_get_groups_by_post_type',
			],
		];

		foreach ( $calls as $file => $functions ) {
			if ( ! is_readable( $file ) ) {
				return false;
			}

			require_once $file;

			foreach ( $functions as $function ) {
				if ( ! function_exists( $function ) ) {
					return false;
				}
			}
		}

		return true;
	}

}