<?php

namespace ACA\Types\Service;

use AC;
use ACA\Types\Column;
use ACP;

final class Columns implements AC\Registrable {

	public function register() {
		add_action( 'ac/column_groups', [ $this, 'register_column_groups' ] );
		add_action( 'acp/column_types', [ $this, 'register_columns' ] );
	}

	/**
	 * Add custom columns
	 *
	 * @param AC\ListScreen $list_screen
	 *
	 * @throws \ReflectionException
	 */
	public function register_columns( AC\ListScreen $list_screen ) {

		switch ( true ) {

			// Post and Media
			case $list_screen instanceof AC\ListScreenPost :
				$list_screen->register_column_type( new Column\Post );
				$list_screen->register_column_types_from_dir( 'ACA\Types\Column\Post' );

				break;
			case $list_screen instanceof AC\ListScreen\User :
				$list_screen->register_column_type( new Column\User );

				break;
			case $list_screen instanceof ACP\ListScreen\Taxonomy :
				$list_screen->register_column_type( new Column\Taxonomy );

				break;
		}
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_column_groups( $groups ) {
		$groups->register_group( 'types', 'Toolset Types', 11 );
	}

}