<?php

namespace ACA\Types\Editing\Storage;

class RepeatableDate extends Repeater {

	public function get( $id ) {
		return array_map( [ $this, 'time_to_date' ], parent::get( $id ) ); // TODO: Change the autogenerated stub
	}

	public function update( $id, $value ) {
		$value = is_array( $value ) ? array_map( 'strtotime', $value ) : false;

		return parent::update( $id, $value );
	}

	private function time_to_date( $timestamp ) {
		return date( 'Y-m-d', $timestamp );
	}

}