<?php

namespace ACA\Types\Editing\Storage;

use ACP;

class File extends ACP\Editing\Storage\Meta {

	public function get( $id ) {
		$raw = parent::get( $id );

		return $raw ? attachment_url_to_postid( $raw ) : false;
	}

	public function update( $id, $value ) {
		$_value = is_numeric( $value ) ? wp_get_attachment_url( $value ) : $value;

		return parent::update( $id, $_value );
	}

}