<?php

namespace ACA\Types\Editing\Post;

use AC;
use AC\Request;
use ACP;

abstract class Relationship
	implements ACP\Editing\PaginatedOptions, ACP\Editing\Service {

	/**
	 * @var string
	 */
	protected $related_post_type;

	/**
	 * @var string
	 */
	protected $relationship;

	/**
	 * @var AC\Column
	 */
	private $column;

	abstract protected function connect_post( $source_id, $connect_id );

	abstract protected function disconnect_post( $source_id, $connect_id );

	public function __construct( $column, $relationship, $related_post_type ) {
		$this->column = $column;
		$this->relationship = $relationship;
		$this->related_post_type = $related_post_type;
	}

	public function get_view( $context ) {
		return ( new ACP\Editing\View\AjaxSelect() )->set_multiple( true )->set_clear_button( true );
	}

	public function get_paginated_options( $s, $paged, $id = null ) {
		$args = [
			's'         => $s,
			'post_type' => $this->related_post_type,
			'paged'     => $paged,
		];

		$entities = new ACP\Helper\Select\Entities\Post( $args );

		return new AC\Helper\Select\Options\Paginated(
			$entities,
			new ACP\Helper\Select\Formatter\PostTitle( $entities )
		);
	}

	public function get_value( $id ) {
		$post_ids = $this->get_ids_from_column( $id );
		$value = [];

		if ( $post_ids ) {
			foreach ( (array) $post_ids as $_id ) {
				$value[ $_id ] = get_post_field( 'post_title', $_id );
			}
		}

		return $value;
	}

	/**
	 * @param $id
	 *
	 * @return int[]
	 */
	private function get_ids_from_column( $id ) {
		$post_ids = $this->column->get_raw_value( $id );

		return $post_ids instanceof AC\Collection
			? $post_ids->all()
			: (array) $post_ids;
	}

	public function update( Request $request ) {
		$id = $request->get( 'id' );
		$value = $request->get( 'value', [] );

		$old_ids = $this->get_ids_from_column( $id );

		if ( ! $value ) {
			$value = [];
		}

		foreach ( $old_ids as $post_id ) {
			if ( ! in_array( $post_id, $value ) ) {
				$this->disconnect_post( $id, $post_id );
			}
		}

		foreach ( $value as $post_id ) {
			if ( in_array( $post_id, $old_ids ) ) {
				continue;
			}

			$this->connect_post( $id, $post_id );
		}

		return true;
	}

}