<?php
/*
Plugin Name: 	Admin Columns Pro - Toolset Types
Version:        1.8
Description: 	Supercharges your Admin Columns Pro with unique Toolset Types columns.
Author:         AdminColumns.com
Author URI:     https://www.admincolumns.com
Plugin URI:     https://www.admincolumns.com
Text Domain: 	codepress-admin-columns
Requires PHP:   5.6.20
*/

use AC\Plugin\Version;
use ACA\Types\Dependencies;
use ACA\Types\Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_admin() ) {
	return;
}

// Don't run the bootstrap during plugin updates
if ( isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], [ 'update-plugin', 'do-plugin-upgrade', 'update-selected' ] ) ) {
	return;
}

define( 'ACA_TYPES_VERSION', '1.8' );

require_once __DIR__ . '/classes/Dependencies.php';

add_action( 'after_setup_theme', function () {
	$dependencies = new Dependencies( plugin_basename( __FILE__ ), ACA_TYPES_VERSION );
	$dependencies->requires_acp( '5.7' );
	$dependencies->requires_php( '5.6.20' );

	$min_required_types_version = '3.4';

	if ( ! class_exists( 'Types_Main', false ) || ! defined( 'TYPES_VERSION' ) || version_compare( TYPES_VERSION, $min_required_types_version, '<=' ) ) {
		$dependencies->add_missing_plugin( __( 'Toolset Types', 'wpcf' ), $dependencies->get_search_url( 'Toolset Types' ), $min_required_types_version );
	}

	if ( $dependencies->has_missing() ) {
		return;
	}

	$class_map = __DIR__ . '/config/autoload-classmap.php';

	if ( is_readable( $class_map ) ) {
		AC\Autoloader::instance()->register_class_map( require $class_map );
	} else {
		AC\Autoloader::instance()->register_prefix( 'ACA\Types', __DIR__ . '/classes' );
	}

	$addon = new Types( __FILE__, new Version( ACA_TYPES_VERSION ) );
	$addon->register();
} );