<?php

namespace ACA\Types\Column\Post;

use AC;
use ACA\Types\Settings;

class Relationship extends AC\Column {

	public function __construct() {
		$this->set_type( 'column-types_relationship' )
		     ->set_label( 'Toolset Types - Relationship' )
		     ->set_group( 'types' );
	}

	public function get_raw_value( $id ) {
		return new AC\Collection( toolset_get_related_posts( $id, $this->get_relationship_setting()->get_relationship(), $this->get_relationship_type() ) );
	}

	/*
	 * TODO: Column does not work anymore since at least Toolset Types 3.3
	 */
	public function is_valid() {
		return false;
	}

	public function register_settings() {
		$this->add_setting( new Settings\Relationship( $this ) );
	}

	private function get_relationship_type() {
		$relationship = $this->get_relationship_setting()->get_relationship_object();

		$parent_type = $relationship->get_parent_type();

		if ( ! in_array( $this->get_post_type(), $parent_type->get_types() ) ) {
			return 'child';
		}

		return 'parent';

	}

	/**
	 * @return false|Settings\Relationship
	 */
	public function get_relationship_setting() {
		$setting = $this->get_setting( 'relationship' );

		if ( ! $setting instanceof Settings\Relationship ) {
			return false;
		}

		return $setting;
	}

}