<?php

namespace ACA\Pods;

use AC;
use AC\Plugin\Version;
use AC\PluginInformation;
use AC\Registrable;
use ACA\Pods\Service;

class Pods extends AC\Plugin {

	public function __construct( $file, Version $version ) {
		parent::__construct( $file, $version );
	}

	public function register() {
		$plugin_information = new PluginInformation( $this->get_basename() );
		$setup_factory = new AC\Plugin\SetupFactory( 'aca_pods_version', $this->get_version() );

		$services = [
			new Service\Columns(),
			new Service\Scripts( $this->get_location() ),
			new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::SITE ) ),
		];

		if ( $plugin_information->is_network_active() ) {
			$services[] = new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::NETWORK ) );
		}

		array_map( [ $this, 'register_service' ], $services );
	}

	private function register_service( $service ) {
		if ( $service instanceof Registrable ) {
			$service->register();
		}
	}

}