<?php
/*
Plugin Name: 	Admin Columns Pro - Pods
Version: 		1.7
Description: 	Supercharges your Admin Columns Pro with unique Pods columns.
Author:         AdminColumns.com
Author URI:     https://www.admincolumns.com
Plugin URI:     https://www.admincolumns.com
Text Domain: 	codepress-admin-columns
Requires PHP:   5.6.20
*/

use AC\Plugin\Version;
use ACA\Pods\Dependencies;
use ACA\Pods\Pods;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_admin() ) {
	return;
}

// Don't run the bootstrap during plugin updates
if ( isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], [ 'update-plugin', 'do-plugin-upgrade', 'update-selected' ] ) ) {
	return;
}

define( 'ACA_PODS_VERSION', '1.7' );

require_once __DIR__ . '/classes/Dependencies.php';

add_action( 'after_setup_theme', function () {
	$dependencies = new Dependencies( plugin_basename( __FILE__ ), ACA_PODS_VERSION );
	$dependencies->requires_acp( '5.7' );
	$dependencies->requires_php( '5.6.20' );

	$min_required_pods_version = '2.7';

	if ( ! function_exists( 'pods' ) || ! defined( 'PODS_VERSION' ) || ! version_compare( PODS_VERSION, $min_required_pods_version, '>=' ) ) {
		$dependencies->add_missing_plugin( __( 'Pods', 'pods' ), $dependencies->get_search_url( 'Pods' ), $min_required_pods_version );
	}

	if ( $dependencies->has_missing() ) {
		return;
	}

	$class_map = __DIR__ . '/config/autoload-classmap.php';

	if ( is_readable( $class_map ) ) {
		AC\Autoloader::instance()->register_class_map( require $class_map );
	} else {
		AC\Autoloader::instance()->register_prefix( 'ACA\Pods', __DIR__ . '/classes' );
	}

	$addon = new Pods( __FILE__, new Version( ACA_PODS_VERSION ) );
	$addon->register();
} );