<?php

namespace ACA\Pods\Field\Pick;

use AC\Settings;
use ACA\Pods\Editing;
use ACA\Pods\Field;
use ACA\Pods\Search;

class Comment extends Field\Pick {

	public function get_value( $id ) {
		$ids = $this->get_raw_value( $id );
		$values = array();

		if ( empty( $ids ) ) {
			return $this->column->get_empty_char();
		}

		foreach ( $ids as $comment_id ) {
			$values[] = $this->column->get_formatted_value( $comment_id, $comment_id );
		}

		return implode( '<br>', $values );
	}

	public function get_raw_value( $id ) {
		return $this->get_ids_from_array( parent::get_raw_value( $id ), 'comment_ID' );
	}

	public function editing() {
		return new Editing\PickComments( $this->column() );
	}

	public function search() {
		return new Search\PickComment( $this->column()->get_meta_key(), $this->column()->get_meta_type() );
	}

	public function get_dependent_settings() {
		return array(
			new Settings\Column\Comment( $this->column ),
		);
	}

}