<?php

namespace ACA\NF;

use AC;
use ACP\Filtering\Filterable;

class TableScreen implements AC\Registrable {

	/**
	 * @var AC\Asset\Location\Absolute
	 */
	private $location;

	public function __construct( AC\Asset\Location\Absolute $location ) {
		$this->location = $location;
	}

	public function register() {
		add_action( 'ac/table/list_screen', [ $this, 'disable_default_date_filter' ] );
		add_action( 'ac/table_scripts', [ $this, 'table_scripts' ] );
	}

	public function disable_default_date_filter( AC\ListScreen $list_screen ) {
		if ( ! $list_screen instanceof Filterable ) {
			return;
		}

		$model = $list_screen->filtering();

		if ( $model instanceof Filtering\Date && $model->hide_default_date_dropdown() ) {
			?>
			<style>
				.tablenav input[name=begin_date],
				.tablenav input[name=end_date] {
					display: none !important;
				}
			</style>

			<?php
		}
	}

	public function table_scripts() {
		$style = new AC\Asset\Style( 'aca-ninjaforms-table', $this->location->with_suffix( 'assets/css/ninjaforms.css' ) );
		$style->enqueue();

		$script = new AC\Asset\Script( 'aca-ninjaforms-table', $this->location->with_suffix( 'assets/js/ninjaforms.js' ), [ 'jquery' ] );
		$script->enqueue();
	}

}