<?php

namespace ACA\NF\Sorting\Submission;

use ACA\NF\Column;
use ACP;

/**
 * @property Column\Submission\Lists $column
 */
class Lists extends ACP\Sorting\AbstractModel {

	/**
	 * @var string
	 */
	private $meta_key;

	/**
	 * @var array
	 */
	private $labels;

	public function __construct( $meta_key, array $labels ) {
		parent::__construct();

		$this->meta_key = $meta_key;
		$this->labels = $labels;
	}

	public function get_sorting_vars() {
		return [
			'ids' => $this->get_sorted_ids(),
		];
	}

	/**
	 * @param mixed $value
	 *
	 * @return array
	 */
	private function get_choice_label( $value ) {
		$labels = [];

		foreach ( $this->labels as $val => $label ) {
			if ( in_array( $val, (array) $value ) ) {
				$labels[] = $label;
			}
		}

		return $labels;
	}

	/**
	 * @return array
	 */
	public function get_sorted_ids() {
		$return_posts = [];

		foreach ( $posts = $this->strategy->get_results() as $post_id ) {
			$meta_value = (array) get_post_meta( $post_id, $this->meta_key, true );
			$return_posts[ $post_id ] = $meta_value;

			if ( ! empty( $meta_value ) ) {
				$label = $this->get_choice_label( $meta_value );

				if ( $label ) {
					$return_posts[ $post_id ] = $label[0];
				}
			}
		}

		asort( $return_posts );

		$ids = array_keys( $return_posts );

		if ( 'DESC' === $this->get_order() ) {
			$ids = array_reverse( $ids );
		}

		return $ids;
	}

}