<?php

namespace ACA\NF;

use AC;
use AC\DefaultColumnsRepository;
use NF_Database_Models_Form;

/**
 * @since 1.0
 */
final class NinjaForms extends AC\Plugin {

	public function __construct( $file ) {
		parent::__construct( $file, 'aca_ninja_forms' );
	}

	/**
	 * Register hooks
	 */
	public function register() {
		add_action( 'ac/column_groups', [ $this, 'register_column_group' ] );
		add_action( 'ac/list_screens', [ $this, 'register_list_screen' ] );
		add_action( 'ac/list_screen_groups', [ $this, 'register_list_screen_group' ] );
		add_action( 'acp/column_types', [ $this, 'register_columns' ] );
		add_action( 'acp/editing/saved', [ $this, 'add_form_id_to_ajax_save' ] );

		add_filter( 'acp/quick_add/enable', [ $this, 'disable_quick_add' ], 10, 2 );

		$table = new TableScreen( $this->get_location() );
		$table->register();
	}

	public function disable_quick_add( $enabled, AC\ListScreen $list_screen ) {
		if ( $list_screen instanceof ListScreen\Submission ) {
			$enabled = false;
		}

		return $enabled;
	}

	/**
	 * The 'ninja_forms_custom_columns' ( which display the column value ) depends on $_GET['form_id'] to be set.
	 *
	 * @param AC\Column $column
	 */
	public function add_form_id_to_ajax_save( $column ) {
		$list_screen = $column->get_list_screen();

		if ( ! $list_screen instanceof ListScreen\Submission ) {
			return;
		}

		$_GET['form_id'] = $list_screen->get_form_id();
	}

	/**
	 * @param string $type Field type (Textbox, Email, Textarea etc.)
	 *                     Full list in ninja-forms/includes/Fields
	 *
	 * @return AC\Column|false
	 */
	private function get_column_by_type( $type ) {

		if ( 'list' === $type ) {
			$type = 'lists';
		}

		$class_name = 'ACA\NF\Column\Submission\\' . ucfirst( $type );

		if ( ! class_exists( $class_name ) ) {
			return false;
		}

		return new $class_name;
	}

	/**
	 * @param AC\ListScreen $list_screen
	 */
	public function register_columns( $list_screen ) {
		if ( ! $list_screen instanceof ListScreen\Submission ) {
			return;
		}

		$form = Ninja_Forms()->form( $list_screen->get_form_id() );

		// Ninja Forms default heading
		foreach ( ( new DefaultColumnsRepository() )->get( $list_screen->get_key() ) as $name => $label ) {

			// skip checkbox
			if ( 'cb' === $name ) {
				continue;
			}

			// register publish date
			if ( 'sub_date' === $name ) {
				$list_screen->register_column_type( new Column\Submission\DatePublished );
				continue;
			}

			// register Id
			if ( 'id' === $name ) {
				$list_screen->register_column_type( new Column\Submission\Id );
				continue;
			}

			$field = $form->get_field( $name );
			$column = $this->get_column_by_type( $field->get_setting( 'type' ) );

			if ( $column ) {
				$column
					->set_type( $name )
					->set_label( $label );

				$list_screen->register_column_type( $column );
			}
		}

	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_list_screen_group( $groups ) {
		$groups->register_group( 'ninjaforms', __( 'Ninja Forms', 'codepress-admin-columns' ), 8 );
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_column_group( $groups ) {
		$groups->register_group( 'ninjaforms', __( 'Ninja Forms', 'codepress-admin-columns' ), 11 );
	}

	public function register_list_screen( AC\ListScreens $list_screens ) {
		$forms = Ninja_Forms()->form()->get_forms();
		if ( $forms ) {
			/* @var NF_Database_Models_Form $form */
			foreach ( $forms as $form ) {
				$list_screens->register_list_screen( new ListScreen\Submission( $form->get_id() ) );
			}
		}
	}

}