<?php

namespace ACA\NF;

use ACA\NF\Column\Submission;
use ACP;

class Editing extends ACP\Editing\Service\BasicStorage {

	/**
	 * @var Submission
	 */
	protected $column;

	/**
	 * @var ACP\Editing\View
	 */
	private $view;

	

	public function __construct( Column\Submission $column, $view = null ) {
		parent::__construct( new ACP\Editing\Storage\Post\Meta( $column->get_meta_key() ) );

		$this->column = $column;
		$this->view = $view;
	}

	public function get_view( $context ) {
		$view = $this->view ?: new ACP\Editing\View\Text();

		return $this->set_default_view_arguments( $view );
	}

	protected function set_default_view_arguments( ACP\Editing\View $view ) {
		if ( $view instanceof ACP\Editing\View\Placeholder && $this->column->get_field_setting( 'placeholder' ) ) {
			$view->set_placeholder( $this->column->get_field_setting( 'placeholder' ) );
		}

		$required = $this->column->get_field_setting( 'required' );

		return $view->set_required( $required )
		            ->set_clear_button( ! $required );
	}

	public function get_value( $id ) {
		$value = parent::get_value( $id );

		return null !== $value ? $value : false;
	}

}