<?php

namespace ACA\NF\Column\Submission;

use ACA\NF\Column\Submission;
use ACA\NF\Editing;
use ACP;
use ACP\Sorting\Type\DataType;

class Product extends Submission {

	public function sorting() {
		return new ACP\Sorting\Model\Post\Meta( $this->get_meta_key(), new DataType( DataType::NUMERIC ) );
	}

	public function filtering() {
		$model = new ACP\Filtering\Model\Meta( $this );
		$model->set_ranged( true );
		$model->set_data_type( 'numeric' );

		return $model;
	}

	public function editing() {
		return new Editing\Number( $this );
	}

}