<?php

namespace ACA\NF\Column\Submission;

use ACA\NF\Column\Submission;
use ACP;
use ACP\Sorting\Type\DataType;

class Date extends Submission {

	public function sorting() {
		return new ACP\Sorting\Model\Post\Meta( $this->get_meta_key(), new DataType( DataType::DATE ) );
	}

	public function search() {
		return 'YYYY-MM-DD' === $this->get_field_setting( 'date_format' )
			? new ACP\Search\Comparison\Meta\DateTime\ISO( $this->get_meta_key(), $this->get_meta_type() )
			: false;
	}

}