<?php

namespace ACA\MetaBox\Sorting\Model;

use ACP\Sorting\AbstractModel;
use ACP\Sorting\Type\CastType;
use ACP\Sorting\Type\DataType;

class Table extends AbstractModel {

	/**
	 * @var string
	 */
	private $table_name;

	/**
	 * @var string
	 */
	private $meta_key;

	public function __construct( $table_name, $meta_key, DataType $data_type = null ) {
		parent::__construct( $data_type );

		$this->table_name = $table_name;
		$this->meta_key = $meta_key;
	}

	public function get_sorting_vars() {
		global $wpdb;

		$cast_type = CastType::create_from_data_type( $this->data_type )->get_value();

		$sql = sprintf( "
					SELECT ID 
					FROM %s 
					ORDER BY CAST(%s AS %s) %s
				", $this->table_name, esc_sql( $this->meta_key ), $cast_type, $this->get_order() );

		return [
			'ids' => $wpdb->get_col( $sql ),
		];
	}

}