<?php

namespace ACA\MetaBox\Sorting\Factory;

use ACA\MetaBox;
use ACA\MetaBox\Column;
use ACA\MetaBox\Sorting;
use ACP;
use ACP\Sorting\Model\Disabled;
use ACP\Sorting\Type\DataType;

final class Date extends Sorting\Factory implements MetaBox\Sorting\CloneableFactory, Sorting\TableStorageFactory {

	public function create_table_storage( Column $column ) {
		if ( ! $column->is_clonable() ) {
			return new Sorting\Model\Table( $column->get_storage_table(), $column->get_meta_key() );
		}

		return new Disabled();
	}

	protected function create_default( Column $column ) {
		/** @var Column\Date $column */
		if ( $column->get_saved_format() === 'U' ) {
			return ( new ACP\Sorting\Model\MetaFactory() )->create( $column->get_meta_type(), $column->get_meta_key(), new DataType( DataType::NUMERIC ) );
		}

		return ( new ACP\Sorting\Model\MetaFactory() )->create( $column->get_meta_type(), $column->get_meta_key() );
	}

	public function create_cloneable( Column $column ) {
		return new Disabled();
	}

}