<?php

namespace ACA\MetaBox;

use AC;
use AC\PluginInformation;
use AC\Registrable;
use ACA\MetaBox\Service;
use MB_Comment_Meta_Box;

class MetaBox extends AC\Plugin {

	public function __construct( $file, AC\Plugin\Version $version ) {
		parent::__construct( $file, $version );
	}

	/**
	 * Register hooks
	 */
	public function register() {
		$plugin_information = new PluginInformation( $this->get_basename() );
		$setup_factory = new AC\Plugin\SetupFactory( 'aca_metabox_version', $this->get_version() );

		$services = [
			new Service\Columns(),
			new Service\QuickAdd(),
			new Service\Scripts( $this->get_location() ),
			new Service\Storage(),
			new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::SITE ) ),
		];

		if ( $plugin_information->is_network_active() ) {
			$services[] = new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::NETWORK ) );
		}

		array_map( [ $this, 'register_service' ], $services );
	}

	private function register_service( $service ) {
		if ( $service instanceof Registrable ) {
			$service->register();
		}
	}

}