<?php

namespace ACA\MetaBox\Editing\Storage;

use RWMB_Taxonomy_Field;
use WP_Term;

class TermField extends Field {

	public function get( $id ) {
		$term = rwmb_get_value( $this->meta_key, [ 'object_type' => $this->meta_type->get() ], $id );

		return $term instanceof WP_Term
			? $term->term_id
			: null;
	}

	public function update( $id, $value ) {
		if ( $value ) {
			$term = get_term( $value );
			$value = $term ? $term->slug : '';
		}

		RWMB_Taxonomy_Field::save( $value, null, $id, $this->field_settings );

		return true;
	}

}