<?php

namespace ACA\MetaBox\Editing\Storage;

use ACP;
use MetaBox\CustomTable\Cache;
use MetaBox\CustomTable\Storage;

class CustomTable implements ACP\Editing\Storage {

	/**
	 * @var Storage
	 */
	private $storage;

	/**
	 * @var string
	 */
	private $meta_key;

	/**
	 * @var string
	 */
	private $table;

	public function __construct( Storage $storage, $table, $meta_key ) {
		$this->storage = $storage;
		$this->meta_key = $meta_key;
		$this->table = $table;
	}

	public function get( $id ) {
		$row = Cache::get( $id, $this->table );

		$value = isset( $row[ $this->meta_key ] ) ? $row[ $this->meta_key ] : false;

		$unserialize = @unserialize( $value );

		return $unserialize !== false ? $unserialize : $value;
	}

	public function update( $id, $value ) {
		$row = Cache::get( $id, $this->table );

		if ( is_array( $value ) ) {
			$value = serialize( $value );
		}

		$row[ $this->meta_key ] = $value;

		if ( $this->storage->row_exists( $id ) ) {
			$this->storage->update_row( $id, $row );
		} else {
			$this->storage->insert_row( $id, $row );
		}

		Cache::set( $id, $this->table, $row );

		return true;
	}

}