<?php

namespace ACA\MetaBox\Editing\ServiceFactory;

use ACA\MetaBox\Column;
use ACA\MetaBox\Editing\StorageFactory;
use ACP\Editing\Service\Basic;
use ACP\Editing\View;

final class Slider {

	public function create( Column $column ) {
		return new Basic(
			$this->create_view( $column ),
			( new StorageFactory() )->create( $column )
		);
	}

	/**
	 * @param Column $column
	 *
	 * @return View
	 */
	private function create_view( Column $column ) {
		if ( $column->is_clonable() ) {
			return ( new View\MultiInput() )->set_sub_type( 'number' )->set_clear_button( true );
		}

		$view = new View\Number();

		$options = $column->get_field_setting( 'js-options' );

		$view->set_min( isset( $options['min'] ) ? $options['min'] : 0 );
		$view->set_max( isset( $options['max'] ) ? $options['max'] : 100 );
		$view->set_step( isset( $options['step'] ) ? $options['step'] : 1 );

		return $view;
	}

}