<?php

namespace ACA\MetaBox\Editing\Service;

use ACA;
use ACP;
use ACP\Editing\PaginatedOptions;
use ACP\Editing\Service\BasicStorage;
use ACP\Editing\Storage;

class TaxonomyAdvanced extends BasicStorage implements PaginatedOptions {

	/**
	 * @var string
	 */
	private $taxonomy;

	public function __construct( Storage $storage, $taxonomy ) {
		parent::__construct( $storage );

		$this->taxonomy = $taxonomy;
	}

	public function get_view( $context ) {
		return ( new ACP\Editing\View\AjaxSelect() )->set_clear_button( true );
	}

	public function get_value( $id ) {
		$value = parent::get_value( $id );

		return is_numeric( $value )
			? [ $value => ac_helper()->taxonomy->get_term_display_name( get_term( $value ) ) ]
			: false;
	}

	public function get_paginated_options( $search, $page, $id = null ) {
		return new ACP\Helper\Select\Paginated\Terms( $search, $page, (array) $this->taxonomy );
	}

}