<?php

namespace ACA\MetaBox\Editing\Service;

use ACA;
use ACP;

class Taxonomy extends ACP\Editing\Service\BasicStorage implements ACP\Editing\PaginatedOptions {

	/**
	 * @var string|array
	 */
	protected $taxonomy;

	/**
	 * @var bool
	 */
	protected $advanced;

	public function __construct( ACP\Editing\Storage $storage, $taxonomy ) {
		parent::__construct( $storage );

		$this->taxonomy = $taxonomy;
	}

	public function get_view( $context ) {
		return new ACP\Editing\View\AjaxSelect();
	}

	public function get_value( $id ) {
		$value = parent::get_value( $id );

		return $value
			? [ $value => ac_helper()->taxonomy->get_term_display_name( get_term( $value ) ) ]
			: false;
	}

	public function get_paginated_options( $s, $paged, $id = null ) {
		return new ACP\Helper\Select\Paginated\Terms( $s, $paged, $this->taxonomy, $this->query_args ?: [] );
	}

}