<?php

namespace ACA\MetaBox\Editing\Service;

use AC\Request;
use ACA;
use ACP;
use ACP\Editing\PaginatedOptions;
use ACP\Editing\Service\BasicStorage;
use ACP\Helper\Select\Paginated\Terms;
use WP_Term;

class TaxonomiesAdvanced extends BasicStorage implements PaginatedOptions {

	/**
	 * @var string|array
	 */
	protected $taxonomy;

	public function __construct( ACP\Editing\Storage $storage, $taxonomy ) {
		parent::__construct( $storage );

		$this->taxonomy = $taxonomy;
	}

	public function get_view( $context ) {
		return ( new ACP\Editing\View\AjaxSelect() )->set_clear_button( true )->set_multiple( true );
	}

	public function get_value( $id ) {
		$value = parent::get_value( $id );

		if ( empty( $value ) ) {
			return false;
		}

		$value = is_array( $value ) ? $value[0] : $value;
		$result = [];

		foreach ( explode( ',', $value ) as $term_id ) {
			$term = get_term( $term_id );
			if ( $term instanceof WP_Term ) {
				$result[ $term_id ] = $term->name;
			}
		}

		return $result;
	}

	public function update( Request $request ) {
		$value = $request->get( 'value', [] );

		if ( ! empty( $value ) ) {
			$request->get_parameters()->set( 'value', implode( ',', $value ) );
		}

		parent::update( $request );
	}

	public function get_paginated_options( $search, $page, $id = null ) {
		return new Terms( $search, $page, $this->taxonomy );
	}

}