<?php

namespace ACA\MetaBox\Editing\Service;

use AC\Request;
use ACA;
use ACP;
use ACP\Editing\View\AjaxSelect;
use RWMB_Taxonomy_Field;

class Taxonomies implements ACP\Editing\Service, ACP\Editing\PaginatedOptions {

	/**
	 * @var string
	 */
	private $meta_type;

	/**
	 * @var string
	 */
	private $meta_key;

	/**
	 * @var array
	 */
	private $field_settings;

	/**
	 * @var string|array
	 */
	private $taxonomy;

	public function __construct( $meta_key, $meta_type, $field_settings, $taxonomy ) {
		$this->meta_key = $meta_key;
		$this->meta_type = $meta_type;
		$this->field_settings = $field_settings;
		$this->taxonomy = $taxonomy;
	}

	public function get_view( $context ) {
		return ( new AjaxSelect() )->set_multiple( true )->set_clear_button( true );
	}

	public function get_value( $id ) {
		$terms = rwmb_get_value( $this->meta_key, [ 'object_type' => $this->meta_type ], $id );
		$result = [];
		foreach ( $terms as $term ) {
			if ( $term instanceof \WP_Term ) {
				$result[ $term->term_id ] = $term->name;
			}
		}

		return $result;
	}

	public function update( Request $request ) {
		$value = array_map( 'intval', (array) $request->get( 'value', [] ) );

		RWMB_Taxonomy_Field::save( $value, null, $request->get( 'id' ), $this->field_settings );

		return true;
	}

	public function get_paginated_options( $search, $page, $id = null ) {
		return new ACP\Helper\Select\Paginated\Terms( $search, $page, (array) $this->taxonomy );
	}

}