<?php

namespace ACA\MetaBox\Column;

use ACA\MetaBox\Editing;
use ACP\Editing\Service\Basic;
use ACP\Editing\View;

class ImageSelect extends Select {

	public function format_single_value( $value, $id = null ) {
		if ( ! $value ) {
			return $this->get_empty_char();
		}

		if ( $this->is_multiple() ) {
			return implode( ', ', (array) $value );
		}

		return $value;
	}

	public function editing() {
		if ( $this->is_clonable() ) {
			return false;
		}

		return new Basic(
			( new View\AdvancedSelect( $this->get_field_options() ) )->set_multiple( $this->get_field_setting( 'multiple' ) ),
			( new Editing\StorageFactory() )->create( $this )
		);
	}

	public function get_field_options() {
		if ( empty( $this->get_field_setting( 'options' ) ) ) {
			return [];
		}

		$options = array_keys( $this->get_field_setting( 'options' ) );

		return array_combine( $options, $options );
	}

}