<?php
/*
Plugin Name:    Admin Columns Pro - Meta Box
Version:        1.3
Description:    Supercharges Admin Columns Pro with columns for Meta Box.
Author:         AdminColumns.com
Author URI:     https://www.admincolumns.com
Plugin URI:     https://www.admincolumns.com
Text Domain:    codepress-admin-columns
Requires PHP:   5.6.20
*/

use AC\Plugin\Version;
use ACA\MetaBox\Dependencies;
use ACA\MetaBox\MetaBox;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_admin() ) {
	return;
}

define( 'ACA_MB_VERSION', '1.3' );

// Don't run the bootstrap during plugin updates
if ( isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], [ 'update-plugin', 'do-plugin-upgrade', 'update-selected' ] ) ) {
	return;
}

require_once __DIR__ . '/classes/Dependencies.php';

add_action( 'after_setup_theme', function () {
	$dependencies = new Dependencies( plugin_basename( __FILE__ ), ACA_MB_VERSION );
	$dependencies->requires_acp( '5.7' );
	$dependencies->requires_php( '5.6.20' );

	if ( ! class_exists( 'RWMB_Loader', false ) ) {
		$dependencies->add_missing_plugin( 'Meta Box', 'https://metabox.io/' );
	}

	if ( $dependencies->has_missing() ) {
		return;
	}

	$class_map = __DIR__ . '/config/autoload-classmap.php';

	if ( is_readable( $class_map ) ) {
		AC\Autoloader::instance()->register_class_map( require $class_map );
	} else {
		AC\Autoloader::instance()->register_prefix( 'ACA\MetaBox', __DIR__ . '/classes' );
	}

	$addon = new MetaBox( __FILE__, new Version( ACA_MB_VERSION ) );
	$addon->register();
} );