<?php

namespace ACA\EC\Service;

use AC;
use AC\Registrable;
use ACA\EC\ListScreen;

final class ListScreens implements Registrable {

	public function register() {
		add_action( 'ac/list_screen_groups', [ $this, 'register_list_screen_groups' ] );
		add_action( 'ac/list_screens', [ $this, 'register_list_screens' ] );
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_list_screen_groups( $groups ) {
		$groups->register_group( 'events-calendar', 'Events Calendar', 7 );
	}

	/**
	 * @param AC\AdminColumns $ac
	 */
	public function register_list_screens( AC\ListScreens $list_screens ) {
		$list_screens->register_list_screen( new ListScreen\Event() )
		             ->register_list_screen( new ListScreen\Venue() )
		             ->register_list_screen( new ListScreen\Organizer() );
	}

}